# cybee-sdk
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.30.2
- Package version: 0.30.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cybee_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cybee_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import cybee_sdk
from cybee_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with cybee_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.AgentsApi(api_client)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Approve Agent
        api_instance.approve_agent_agent_agent_id_approve_post(agent_id, cbe_user_org_id=cbe_user_org_id)
    except ApiException as e:
        print("Exception when calling AgentsApi->approve_agent_agent_agent_id_approve_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentsApi* | [**approve_agent_agent_agent_id_approve_post**](docs/AgentsApi.md#approve_agent_agent_agent_id_approve_post) | **POST** /agent/{agent_id}/approve/ | Approve Agent
*AgentsApi* | [**delete_agent_agent_agent_id_delete**](docs/AgentsApi.md#delete_agent_agent_agent_id_delete) | **DELETE** /agent/{agent_id}/ | Delete Agent
*AgentsApi* | [**get_agent_agent_unregistered_get**](docs/AgentsApi.md#get_agent_agent_unregistered_get) | **GET** /agent/unregistered/ | Get Agent
*AgentsApi* | [**list_agent_agent_get**](docs/AgentsApi.md#list_agent_agent_get) | **GET** /agent/ | List Agent
*AgentsApi* | [**update_agent_agent_agent_id_put**](docs/AgentsApi.md#update_agent_agent_agent_id_put) | **PUT** /agent/{agent_id}/ | Update Agent
*CmdbApi* | [**list_cmdb_items_cmdb_machines_get**](docs/CmdbApi.md#list_cmdb_items_cmdb_machines_get) | **GET** /cmdb/machines/ | List Cmdb Items
*CmdbApi* | [**list_historical_cmdb_items_cmdb_machines_historical_get**](docs/CmdbApi.md#list_historical_cmdb_items_cmdb_machines_historical_get) | **GET** /cmdb/machines/historical/ | List Historical Cmdb Items
*PlansBackupApi* | [**assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**](docs/PlansBackupApi.md#assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/assign-agent/{agent_id}/ | Assign Backup Plan Agent
*PlansBackupApi* | [**assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**](docs/PlansBackupApi.md#assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/assign-schedule/{schedule_id}/ | Assign Backup Plan Schedule
*PlansBackupApi* | [**create_file_backup_plans_plan_backup_file_post**](docs/PlansBackupApi.md#create_file_backup_plans_plan_backup_file_post) | **POST** /plan/backup/file/ | Create File Backup Plans
*PlansBackupApi* | [**create_image_backup_plans_plan_backup_image_post**](docs/PlansBackupApi.md#create_image_backup_plans_plan_backup_image_post) | **POST** /plan/backup/image/ | Create Image Backup Plans
*PlansBackupApi* | [**delete_file_backup_plans_plan_backup_file_plan_id_delete**](docs/PlansBackupApi.md#delete_file_backup_plans_plan_backup_file_plan_id_delete) | **DELETE** /plan/backup/file/{plan_id}/ | Delete File Backup Plans
*PlansBackupApi* | [**delete_image_backup_plans_plan_backup_image_plan_id_delete**](docs/PlansBackupApi.md#delete_image_backup_plans_plan_backup_image_plan_id_delete) | **DELETE** /plan/backup/image/{plan_id}/ | Delete Image Backup Plans
*PlansBackupApi* | [**execute_file_backup_plan_plan_backup_file_plan_id_execute_post**](docs/PlansBackupApi.md#execute_file_backup_plan_plan_backup_file_plan_id_execute_post) | **POST** /plan/backup/file/{plan_id}/execute/ | Execute File Backup Plan
*PlansBackupApi* | [**execute_image_backup_plan_plan_backup_image_plan_id_execute_post**](docs/PlansBackupApi.md#execute_image_backup_plan_plan_backup_image_plan_id_execute_post) | **POST** /plan/backup/image/{plan_id}/execute/ | Execute Image Backup Plan
*PlansBackupApi* | [**get_file_backup_plan_plan_backup_file_plan_id_get**](docs/PlansBackupApi.md#get_file_backup_plan_plan_backup_file_plan_id_get) | **GET** /plan/backup/file/{plan_id}/ | Get File Backup Plan
*PlansBackupApi* | [**get_image_backup_plan_plan_backup_image_plan_id_get**](docs/PlansBackupApi.md#get_image_backup_plan_plan_backup_image_plan_id_get) | **GET** /plan/backup/image/{plan_id}/ | Get Image Backup Plan
*PlansBackupApi* | [**get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get**](docs/PlansBackupApi.md#get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get) | **GET** /plan/backup/backup/run/{plan_run_id}/status/ | Get Running Plan Status
*PlansBackupApi* | [**list_all_backup_history_plan_backup_history_get**](docs/PlansBackupApi.md#list_all_backup_history_plan_backup_history_get) | **GET** /plan/backup/history/ | List All Backup History
*PlansBackupApi* | [**list_all_latest_backup_history_plan_backup_history_latest_get**](docs/PlansBackupApi.md#list_all_latest_backup_history_plan_backup_history_latest_get) | **GET** /plan/backup/history/latest/ | List All Latest Backup History
*PlansBackupApi* | [**list_file_backup_history_plan_backup_file_plan_id_history_get**](docs/PlansBackupApi.md#list_file_backup_history_plan_backup_file_plan_id_history_get) | **GET** /plan/backup/file/{plan_id}/history/ | List File Backup History
*PlansBackupApi* | [**list_file_backup_plans_plan_backup_file_get**](docs/PlansBackupApi.md#list_file_backup_plans_plan_backup_file_get) | **GET** /plan/backup/file/ | List File Backup Plans
*PlansBackupApi* | [**list_image_backup_history_plan_backup_image_plan_id_history_get**](docs/PlansBackupApi.md#list_image_backup_history_plan_backup_image_plan_id_history_get) | **GET** /plan/backup/image/{plan_id}/history/ | List Image Backup History
*PlansBackupApi* | [**list_image_backup_plans_plan_backup_image_get**](docs/PlansBackupApi.md#list_image_backup_plans_plan_backup_image_get) | **GET** /plan/backup/image/ | List Image Backup Plans
*PlansBackupApi* | [**remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**](docs/PlansBackupApi.md#remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/remove-agent/{agent_id}/ | Remove Backup Plan Agent
*PlansBackupApi* | [**remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**](docs/PlansBackupApi.md#remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/remove-schedule/{schedule_id}/ | Remove Backup Plan Schedule
*PlansBackupApi* | [**update_file_backup_plans_plan_backup_file_plan_id_put**](docs/PlansBackupApi.md#update_file_backup_plans_plan_backup_file_plan_id_put) | **PUT** /plan/backup/file/{plan_id}/ | Update File Backup Plans
*PlansBackupApi* | [**update_image_backup_plans_plan_backup_image_plan_id_put**](docs/PlansBackupApi.md#update_image_backup_plans_plan_backup_image_plan_id_put) | **PUT** /plan/backup/image/{plan_id}/ | Update Image Backup Plans
*PlansRestoreApi* | [**assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**](docs/PlansRestoreApi.md#assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/assign-agent/{agent_id}/ | Assign Restore Plan Agent
*PlansRestoreApi* | [**assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**](docs/PlansRestoreApi.md#assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/assign-schedule/{schedule_id}/ | Assign Restore Plan Schedule
*PlansRestoreApi* | [**create_file_restore_plans_plan_restore_file_post**](docs/PlansRestoreApi.md#create_file_restore_plans_plan_restore_file_post) | **POST** /plan/restore/file/ | Create File Restore Plans
*PlansRestoreApi* | [**create_image_restore_plans_plan_restore_image_post**](docs/PlansRestoreApi.md#create_image_restore_plans_plan_restore_image_post) | **POST** /plan/restore/image/ | Create Image Restore Plans
*PlansRestoreApi* | [**delete_file_restore_plans_plan_restore_file_plan_id_delete**](docs/PlansRestoreApi.md#delete_file_restore_plans_plan_restore_file_plan_id_delete) | **DELETE** /plan/restore/file/{plan_id}/ | Delete File Restore Plans
*PlansRestoreApi* | [**delete_image_restore_plans_plan_restore_image_plan_id_delete**](docs/PlansRestoreApi.md#delete_image_restore_plans_plan_restore_image_plan_id_delete) | **DELETE** /plan/restore/image/{plan_id}/ | Delete Image Restore Plans
*PlansRestoreApi* | [**execute_file_restore_plan_plan_restore_file_plan_id_execute_post**](docs/PlansRestoreApi.md#execute_file_restore_plan_plan_restore_file_plan_id_execute_post) | **POST** /plan/restore/file/{plan_id}/execute/ | Execute File Restore Plan
*PlansRestoreApi* | [**execute_image_restore_plan_plan_restore_image_plan_id_execute_post**](docs/PlansRestoreApi.md#execute_image_restore_plan_plan_restore_image_plan_id_execute_post) | **POST** /plan/restore/image/{plan_id}/execute/ | Execute Image Restore Plan
*PlansRestoreApi* | [**get_file_restore_plan_plan_restore_file_plan_id_get**](docs/PlansRestoreApi.md#get_file_restore_plan_plan_restore_file_plan_id_get) | **GET** /plan/restore/file/{plan_id}/ | Get File Restore Plan
*PlansRestoreApi* | [**get_image_restore_plan_plan_restore_image_plan_id_get**](docs/PlansRestoreApi.md#get_image_restore_plan_plan_restore_image_plan_id_get) | **GET** /plan/restore/image/{plan_id}/ | Get Image Restore Plan
*PlansRestoreApi* | [**get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get**](docs/PlansRestoreApi.md#get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get) | **GET** /plan/restore/restore/run/{plan_run_id}/status/ | Get Running Plan Status
*PlansRestoreApi* | [**list_all_latest_restore_history_plan_restore_history_latest_get**](docs/PlansRestoreApi.md#list_all_latest_restore_history_plan_restore_history_latest_get) | **GET** /plan/restore/history/latest/ | List All Latest Restore History
*PlansRestoreApi* | [**list_all_restore_history_plan_restore_history_get**](docs/PlansRestoreApi.md#list_all_restore_history_plan_restore_history_get) | **GET** /plan/restore/history/ | List All Restore History
*PlansRestoreApi* | [**list_file_restore_history_plan_restore_file_plan_id_history_get**](docs/PlansRestoreApi.md#list_file_restore_history_plan_restore_file_plan_id_history_get) | **GET** /plan/restore/file/{plan_id}/history/ | List File Restore History
*PlansRestoreApi* | [**list_file_restore_plans_plan_restore_file_get**](docs/PlansRestoreApi.md#list_file_restore_plans_plan_restore_file_get) | **GET** /plan/restore/file/ | List File Restore Plans
*PlansRestoreApi* | [**list_image_restore_history_plan_restore_image_plan_id_history_get**](docs/PlansRestoreApi.md#list_image_restore_history_plan_restore_image_plan_id_history_get) | **GET** /plan/restore/image/{plan_id}/history/ | List Image Restore History
*PlansRestoreApi* | [**list_image_restore_plans_plan_restore_image_get**](docs/PlansRestoreApi.md#list_image_restore_plans_plan_restore_image_get) | **GET** /plan/restore/image/ | List Image Restore Plans
*PlansRestoreApi* | [**remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**](docs/PlansRestoreApi.md#remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/remove-agent/{agent_id}/ | Remove Restore Plan Agent
*PlansRestoreApi* | [**remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**](docs/PlansRestoreApi.md#remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/remove-schedule/{schedule_id}/ | Remove Restore Plan Schedule
*PlansRestoreApi* | [**update_file_restore_plans_plan_restore_file_plan_id_put**](docs/PlansRestoreApi.md#update_file_restore_plans_plan_restore_file_plan_id_put) | **PUT** /plan/restore/file/{plan_id}/ | Update File Restore Plans
*PlansRestoreApi* | [**update_image_restore_plans_plan_restore_image_plan_id_put**](docs/PlansRestoreApi.md#update_image_restore_plans_plan_restore_image_plan_id_put) | **PUT** /plan/restore/image/{plan_id}/ | Update Image Restore Plans
*PlansScheduleApi* | [**create_plan_schedule_plan_schedule_schedule_post**](docs/PlansScheduleApi.md#create_plan_schedule_plan_schedule_schedule_post) | **POST** /plan/schedule/schedule/ | Create Plan Schedule
*PlansScheduleApi* | [**delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**](docs/PlansScheduleApi.md#delete_plan_schedule_plan_schedule_schedule_schedule_id_delete) | **DELETE** /plan/schedule/schedule/{schedule_id}/ | Delete Plan Schedule
*PlansScheduleApi* | [**list_plan_schedules_plan_schedule_schedule_get**](docs/PlansScheduleApi.md#list_plan_schedules_plan_schedule_schedule_get) | **GET** /plan/schedule/schedule/ | List Plan Schedules
*PlansScheduleApi* | [**update_plan_schedule_plan_schedule_schedule_schedule_id_put**](docs/PlansScheduleApi.md#update_plan_schedule_plan_schedule_schedule_schedule_id_put) | **PUT** /plan/schedule/schedule/{schedule_id}/ | Update Plan Schedule
*StorageAccountApi* | [**create_storage_account_storage_storage_account_post**](docs/StorageAccountApi.md#create_storage_account_storage_storage_account_post) | **POST** /storage/storage-account/ | Create Storage Account
*StorageAccountApi* | [**delete_storage_account_storage_storage_account_storage_account_id_delete**](docs/StorageAccountApi.md#delete_storage_account_storage_storage_account_storage_account_id_delete) | **DELETE** /storage/storage-account/{storage_account_id}/ | Delete Storage Account
*StorageAccountApi* | [**get_storage_account_storage_storage_account_storage_account_id_get**](docs/StorageAccountApi.md#get_storage_account_storage_storage_account_storage_account_id_get) | **GET** /storage/storage-account/{storage_account_id}/ | Get Storage Account
*StorageAccountApi* | [**list_storage_account_storage_storage_account_get**](docs/StorageAccountApi.md#list_storage_account_storage_storage_account_get) | **GET** /storage/storage-account/ | List Storage Account
*StorageAccountApi* | [**update_storage_account_storage_storage_account_storage_account_id_put**](docs/StorageAccountApi.md#update_storage_account_storage_storage_account_storage_account_id_put) | **PUT** /storage/storage-account/{storage_account_id}/ | Update Storage Account
*StorageDestinationApi* | [**create_storage_destination_storage_storage_destination_post**](docs/StorageDestinationApi.md#create_storage_destination_storage_storage_destination_post) | **POST** /storage/storage-destination/ | Create Storage Destination
*StorageDestinationApi* | [**delete_storage_destination_storage_storage_destination_storage_destination_id_delete**](docs/StorageDestinationApi.md#delete_storage_destination_storage_storage_destination_storage_destination_id_delete) | **DELETE** /storage/storage-destination/{storage_destination_id}/ | Delete Storage Destination
*StorageDestinationApi* | [**get_storage_destination_storage_storage_destination_storage_destination_id_get**](docs/StorageDestinationApi.md#get_storage_destination_storage_storage_destination_storage_destination_id_get) | **GET** /storage/storage-destination/{storage_destination_id}/ | Get Storage Destination
*StorageDestinationApi* | [**list_storage_destination_storage_storage_destination_get**](docs/StorageDestinationApi.md#list_storage_destination_storage_storage_destination_get) | **GET** /storage/storage-destination/ | List Storage Destination
*StorageDestinationApi* | [**update_storage_destination_storage_storage_destination_storage_destination_id_patch**](docs/StorageDestinationApi.md#update_storage_destination_storage_storage_destination_storage_destination_id_patch) | **PATCH** /storage/storage-destination/{storage_destination_id}/ | Update Storage Destination
*StorageRepositoryApi* | [**create_repository_storage_repository_post**](docs/StorageRepositoryApi.md#create_repository_storage_repository_post) | **POST** /storage/repository/ | Create Repository
*StorageRepositoryApi* | [**delete_repository_storage_repository_repository_id_delete**](docs/StorageRepositoryApi.md#delete_repository_storage_repository_repository_id_delete) | **DELETE** /storage/repository/{repository_id}/ | Delete Repository
*StorageRepositoryApi* | [**execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get**](docs/StorageRepositoryApi.md#execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get) | **GET** /storage/repository/{repository_id}/maintenance/{maintenance_type}/execute/ | Execute Repository Maintenance
*StorageRepositoryApi* | [**get_repository_maintenance_storage_repository_repository_id_maintenance_get**](docs/StorageRepositoryApi.md#get_repository_maintenance_storage_repository_repository_id_maintenance_get) | **GET** /storage/repository/{repository_id}/maintenance/ | Get Repository Maintenance
*StorageRepositoryApi* | [**get_repository_storage_repository_repository_id_get**](docs/StorageRepositoryApi.md#get_repository_storage_repository_repository_id_get) | **GET** /storage/repository/{repository_id}/ | Get Repository
*StorageRepositoryApi* | [**list_repository_checks_storage_repository_check_history_get**](docs/StorageRepositoryApi.md#list_repository_checks_storage_repository_check_history_get) | **GET** /storage/repository/check-history/ | List Repository Checks
*StorageRepositoryApi* | [**list_repository_prunes_storage_repository_prune_history_get**](docs/StorageRepositoryApi.md#list_repository_prunes_storage_repository_prune_history_get) | **GET** /storage/repository/prune-history/ | List Repository Prunes
*StorageRepositoryApi* | [**list_repository_stats_storage_repository_stats_get**](docs/StorageRepositoryApi.md#list_repository_stats_storage_repository_stats_get) | **GET** /storage/repository/stats/ | List Repository Stats
*StorageRepositoryApi* | [**list_repository_storage_repository_get**](docs/StorageRepositoryApi.md#list_repository_storage_repository_get) | **GET** /storage/repository/ | List Repository
*StorageRepositoryApi* | [**set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post**](docs/StorageRepositoryApi.md#set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post) | **POST** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Set Repository Maintenance
*StorageRepositoryApi* | [**unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete**](docs/StorageRepositoryApi.md#unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete) | **DELETE** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Unset Repository Maintenance
*StorageRepositoryApi* | [**update_repository_storage_repository_repository_id_patch**](docs/StorageRepositoryApi.md#update_repository_storage_repository_repository_id_patch) | **PATCH** /storage/repository/{repository_id}/ | Update Repository


## Documentation For Models

 - [AdditionalAgentFilter](docs/AdditionalAgentFilter.md)
 - [Addr](docs/Addr.md)
 - [AgentInfo](docs/AgentInfo.md)
 - [AgentUpdate](docs/AgentUpdate.md)
 - [BackupError](docs/BackupError.md)
 - [BackupFatalError](docs/BackupFatalError.md)
 - [BackupInfo](docs/BackupInfo.md)
 - [BackupPlanRun](docs/BackupPlanRun.md)
 - [BackupStatus](docs/BackupStatus.md)
 - [BackupSummary](docs/BackupSummary.md)
 - [BackupVerboseStatus](docs/BackupVerboseStatus.md)
 - [CoresGroup](docs/CoresGroup.md)
 - [CreateScheduling](docs/CreateScheduling.md)
 - [CronCalendar](docs/CronCalendar.md)
 - [Dns](docs/Dns.md)
 - [DriveType](docs/DriveType.md)
 - [ExcludeLargerThan](docs/ExcludeLargerThan.md)
 - [ExcludeLargerThan1](docs/ExcludeLargerThan1.md)
 - [FileBackupPlan](docs/FileBackupPlan.md)
 - [FileBackupPlanCreate](docs/FileBackupPlanCreate.md)
 - [FileBackupPlanUpdate](docs/FileBackupPlanUpdate.md)
 - [FileRestorePlan](docs/FileRestorePlan.md)
 - [FileRestorePlanCreate](docs/FileRestorePlanCreate.md)
 - [FileRestorePlanUpdate](docs/FileRestorePlanUpdate.md)
 - [Filesystem](docs/Filesystem.md)
 - [GlobalResticOptions](docs/GlobalResticOptions.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HistoricalMachine](docs/HistoricalMachine.md)
 - [IPVersion](docs/IPVersion.md)
 - [Iface](docs/Iface.md)
 - [ImageBackupPlan](docs/ImageBackupPlan.md)
 - [ImageBackupPlanCreate](docs/ImageBackupPlanCreate.md)
 - [ImageBackupPlanExtension](docs/ImageBackupPlanExtension.md)
 - [ImageBackupPlanUpdate](docs/ImageBackupPlanUpdate.md)
 - [ImageRestorePlan](docs/ImageRestorePlan.md)
 - [ImageRestorePlanCreate](docs/ImageRestorePlanCreate.md)
 - [ImageRestorePlanExtension](docs/ImageRestorePlanExtension.md)
 - [ImageRestorePlanUpdate](docs/ImageRestorePlanUpdate.md)
 - [LocationInner](docs/LocationInner.md)
 - [Machine](docs/Machine.md)
 - [MaintenanceType](docs/MaintenanceType.md)
 - [MassStorage](docs/MassStorage.md)
 - [Memory](docs/Memory.md)
 - [Ntp](docs/Ntp.md)
 - [NtpSynchronized](docs/NtpSynchronized.md)
 - [Os](docs/Os.md)
 - [PageAgentInfo](docs/PageAgentInfo.md)
 - [PageBackupPlanRun](docs/PageBackupPlanRun.md)
 - [PageFileBackupPlan](docs/PageFileBackupPlan.md)
 - [PageFileRestorePlan](docs/PageFileRestorePlan.md)
 - [PageHistoricalMachine](docs/PageHistoricalMachine.md)
 - [PageImageBackupPlan](docs/PageImageBackupPlan.md)
 - [PageImageRestorePlan](docs/PageImageRestorePlan.md)
 - [PageMachine](docs/PageMachine.md)
 - [PageRepository](docs/PageRepository.md)
 - [PageRepositoryChecks](docs/PageRepositoryChecks.md)
 - [PageRepositoryPrunes](docs/PageRepositoryPrunes.md)
 - [PageRepositoryStats](docs/PageRepositoryStats.md)
 - [PageRestorePlanRun](docs/PageRestorePlanRun.md)
 - [PageScheduling](docs/PageScheduling.md)
 - [PageStorageAccount](docs/PageStorageAccount.md)
 - [PageStorageDestination](docs/PageStorageDestination.md)
 - [PageUnregisteredAgentInfo](docs/PageUnregisteredAgentInfo.md)
 - [Partition](docs/Partition.md)
 - [PhyCpu](docs/PhyCpu.md)
 - [PhyDrive](docs/PhyDrive.md)
 - [PlanStatus](docs/PlanStatus.md)
 - [PlanType](docs/PlanType.md)
 - [PrePostRunScript](docs/PrePostRunScript.md)
 - [Repository](docs/Repository.md)
 - [RepositoryChecks](docs/RepositoryChecks.md)
 - [RepositoryCreate](docs/RepositoryCreate.md)
 - [RepositoryMaintenance](docs/RepositoryMaintenance.md)
 - [RepositoryMaintenanceCreateUpdate](docs/RepositoryMaintenanceCreateUpdate.md)
 - [RepositoryPrunes](docs/RepositoryPrunes.md)
 - [RepositoryStats](docs/RepositoryStats.md)
 - [RepositoryStatusEnum](docs/RepositoryStatusEnum.md)
 - [RepositoryUpdate](docs/RepositoryUpdate.md)
 - [ResticBackupInput](docs/ResticBackupInput.md)
 - [ResticBackupOutput](docs/ResticBackupOutput.md)
 - [ResticRestore](docs/ResticRestore.md)
 - [ResticStatsModeEnum](docs/ResticStatsModeEnum.md)
 - [ResticVersionEnum](docs/ResticVersionEnum.md)
 - [RestorationError](docs/RestorationError.md)
 - [RestorationInfo](docs/RestorationInfo.md)
 - [RestorationStatus](docs/RestorationStatus.md)
 - [RestorationSummary](docs/RestorationSummary.md)
 - [RestorePlanRun](docs/RestorePlanRun.md)
 - [RestoreSummary](docs/RestoreSummary.md)
 - [RestoreVerboseStatus](docs/RestoreVerboseStatus.md)
 - [RetentionSettings](docs/RetentionSettings.md)
 - [S3Provider](docs/S3Provider.md)
 - [S3SignatureVersionEnum](docs/S3SignatureVersionEnum.md)
 - [S3StorageAccountConfig](docs/S3StorageAccountConfig.md)
 - [Scheduling](docs/Scheduling.md)
 - [SchedulingLinkedPlans](docs/SchedulingLinkedPlans.md)
 - [Snapshot](docs/Snapshot.md)
 - [StorageAccount](docs/StorageAccount.md)
 - [StorageAccountCreate](docs/StorageAccountCreate.md)
 - [StorageAccountUpdate](docs/StorageAccountUpdate.md)
 - [StorageDestination](docs/StorageDestination.md)
 - [StorageDestinationConfig](docs/StorageDestinationConfig.md)
 - [StorageDestinationCreate](docs/StorageDestinationCreate.md)
 - [StorageDestinationUpdate](docs/StorageDestinationUpdate.md)
 - [StorageFormat](docs/StorageFormat.md)
 - [TimeStamps](docs/TimeStamps.md)
 - [UnregisteredAgentInfo](docs/UnregisteredAgentInfo.md)
 - [UpdateScheduling](docs/UpdateScheduling.md)
 - [ValidationError](docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerToken"></a>
### BearerToken

- **Type**: Bearer authentication

<a id="ZitadelWebAuthorizationBearer"></a>
### ZitadelWebAuthorizationBearer

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://auth.cybee.fr/oauth/v2/authorize
- **Scopes**: N/A


## Author




