"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from cybee_sdk.api.models.additional_agent_filter import AdditionalAgentFilter
from cybee_sdk.api.models.file_restore_plan import FileRestorePlan
from cybee_sdk.api.models.file_restore_plan_create import FileRestorePlanCreate
from cybee_sdk.api.models.file_restore_plan_update import FileRestorePlanUpdate
from cybee_sdk.api.models.image_restore_plan import ImageRestorePlan
from cybee_sdk.api.models.image_restore_plan_create import ImageRestorePlanCreate
from cybee_sdk.api.models.image_restore_plan_update import ImageRestorePlanUpdate
from cybee_sdk.api.models.page_file_restore_plan import PageFileRestorePlan
from cybee_sdk.api.models.page_image_restore_plan import PageImageRestorePlan
from cybee_sdk.api.models.page_restore_plan_run import PageRestorePlanRun
from cybee_sdk.api.models.restoration_info import RestorationInfo

from cybee_sdk.api.api_client import ApiClient, RequestSerialized
from cybee_sdk.api.api_response import ApiResponse
from cybee_sdk.api.rest import RESTResponseType


class PlansRestoreApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Assign Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_with_http_info(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Assign Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_without_preload_content(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Assign Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post_serialize(
        self,
        plan_id,
        agent_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        if agent_id is not None:
            _path_params["agent_id"] = agent_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/{plan_id}/assign-agent/{agent_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Assign Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_with_http_info(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Assign Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_without_preload_content(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Assign Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post_serialize(
        self,
        plan_id,
        schedule_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        if schedule_id is not None:
            _path_params["schedule_id"] = schedule_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/{plan_id}/assign-schedule/{schedule_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def create_file_restore_plans_plan_restore_file_post(
        self,
        file_restore_plan_create: FileRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create File Restore Plans


        :param file_restore_plan_create: (required)
        :type file_restore_plan_create: FileRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_file_restore_plans_plan_restore_file_post_serialize(
            file_restore_plan_create=file_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_file_restore_plans_plan_restore_file_post_with_http_info(
        self,
        file_restore_plan_create: FileRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create File Restore Plans


        :param file_restore_plan_create: (required)
        :type file_restore_plan_create: FileRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_file_restore_plans_plan_restore_file_post_serialize(
            file_restore_plan_create=file_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_file_restore_plans_plan_restore_file_post_without_preload_content(
        self,
        file_restore_plan_create: FileRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create File Restore Plans


        :param file_restore_plan_create: (required)
        :type file_restore_plan_create: FileRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_file_restore_plans_plan_restore_file_post_serialize(
            file_restore_plan_create=file_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_file_restore_plans_plan_restore_file_post_serialize(
        self,
        file_restore_plan_create,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if file_restore_plan_create is not None:
            _body_params = file_restore_plan_create

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/file/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def create_image_restore_plans_plan_restore_image_post(
        self,
        image_restore_plan_create: ImageRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create Image Restore Plans


        :param image_restore_plan_create: (required)
        :type image_restore_plan_create: ImageRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_image_restore_plans_plan_restore_image_post_serialize(
            image_restore_plan_create=image_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_image_restore_plans_plan_restore_image_post_with_http_info(
        self,
        image_restore_plan_create: ImageRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create Image Restore Plans


        :param image_restore_plan_create: (required)
        :type image_restore_plan_create: ImageRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_image_restore_plans_plan_restore_image_post_serialize(
            image_restore_plan_create=image_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_image_restore_plans_plan_restore_image_post_without_preload_content(
        self,
        image_restore_plan_create: ImageRestorePlanCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Image Restore Plans


        :param image_restore_plan_create: (required)
        :type image_restore_plan_create: ImageRestorePlanCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_image_restore_plans_plan_restore_image_post_serialize(
            image_restore_plan_create=image_restore_plan_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_image_restore_plans_plan_restore_image_post_serialize(
        self,
        image_restore_plan_create,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if image_restore_plan_create is not None:
            _body_params = image_restore_plan_create

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/image/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_file_restore_plans_plan_restore_file_plan_id_delete(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_file_restore_plans_plan_restore_file_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_file_restore_plans_plan_restore_file_plan_id_delete_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_file_restore_plans_plan_restore_file_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_file_restore_plans_plan_restore_file_plan_id_delete_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_file_restore_plans_plan_restore_file_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_file_restore_plans_plan_restore_file_plan_id_delete_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/plan/restore/file/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_image_restore_plans_plan_restore_image_plan_id_delete(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_image_restore_plans_plan_restore_image_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_image_restore_plans_plan_restore_image_plan_id_delete_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_image_restore_plans_plan_restore_image_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_image_restore_plans_plan_restore_image_plan_id_delete_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_image_restore_plans_plan_restore_image_plan_id_delete_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_image_restore_plans_plan_restore_image_plan_id_delete_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/plan/restore/image/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def execute_file_restore_plan_plan_restore_file_plan_id_execute_post(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Execute File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_file_restore_plan_plan_restore_file_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def execute_file_restore_plan_plan_restore_file_plan_id_execute_post_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Execute File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_file_restore_plan_plan_restore_file_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def execute_file_restore_plan_plan_restore_file_plan_id_execute_post_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_file_restore_plan_plan_restore_file_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _execute_file_restore_plan_plan_restore_file_plan_id_execute_post_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        additional_agent_filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if additional_agent_filter is not None:
            _body_params = additional_agent_filter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/file/{plan_id}/execute/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def execute_image_restore_plan_plan_restore_image_plan_id_execute_post(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Execute Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_image_restore_plan_plan_restore_image_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def execute_image_restore_plan_plan_restore_image_plan_id_execute_post_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Execute Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_image_restore_plan_plan_restore_image_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def execute_image_restore_plan_plan_restore_image_plan_id_execute_post_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        additional_agent_filter: Optional[AdditionalAgentFilter] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param additional_agent_filter:
        :type additional_agent_filter: AdditionalAgentFilter
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_image_restore_plan_plan_restore_image_plan_id_execute_post_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            additional_agent_filter=additional_agent_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _execute_image_restore_plan_plan_restore_image_plan_id_execute_post_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        additional_agent_filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if additional_agent_filter is not None:
            _body_params = additional_agent_filter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/image/{plan_id}/execute/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_file_restore_plan_plan_restore_file_plan_id_get(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FileRestorePlan:
        """Get File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_file_restore_plan_plan_restore_file_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_file_restore_plan_plan_restore_file_plan_id_get_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FileRestorePlan]:
        """Get File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_file_restore_plan_plan_restore_file_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_file_restore_plan_plan_restore_file_plan_id_get_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get File Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_file_restore_plan_plan_restore_file_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_file_restore_plan_plan_restore_file_plan_id_get_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/file/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_image_restore_plan_plan_restore_image_plan_id_get(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ImageRestorePlan:
        """Get Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_image_restore_plan_plan_restore_image_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_image_restore_plan_plan_restore_image_plan_id_get_with_http_info(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ImageRestorePlan]:
        """Get Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_image_restore_plan_plan_restore_image_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_image_restore_plan_plan_restore_image_plan_id_get_without_preload_content(
        self,
        plan_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Image Restore Plan


        :param plan_id: (required)
        :type plan_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_image_restore_plan_plan_restore_image_plan_id_get_serialize(
            plan_id=plan_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_image_restore_plan_plan_restore_image_plan_id_get_serialize(
        self,
        plan_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/image/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get(
        self,
        plan_run_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RestorationInfo:
        """Get Running Plan Status


        :param plan_run_id: (required)
        :type plan_run_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_serialize(
            plan_run_id=plan_run_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RestorationInfo",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_with_http_info(
        self,
        plan_run_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RestorationInfo]:
        """Get Running Plan Status


        :param plan_run_id: (required)
        :type plan_run_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_serialize(
            plan_run_id=plan_run_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RestorationInfo",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_without_preload_content(
        self,
        plan_run_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Running Plan Status


        :param plan_run_id: (required)
        :type plan_run_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_serialize(
            plan_run_id=plan_run_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RestorationInfo",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get_serialize(
        self,
        plan_run_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_run_id is not None:
            _path_params["plan_run_id"] = plan_run_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/restore/run/{plan_run_id}/status/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_all_latest_restore_history_plan_restore_history_latest_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRestorePlanRun:
        """List All Latest Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_latest_restore_history_plan_restore_history_latest_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_all_latest_restore_history_plan_restore_history_latest_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRestorePlanRun]:
        """List All Latest Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_latest_restore_history_plan_restore_history_latest_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_all_latest_restore_history_plan_restore_history_latest_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Latest Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_latest_restore_history_plan_restore_history_latest_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_all_latest_restore_history_plan_restore_history_latest_get_serialize(
        self,
        page,
        per_page,
        order_by,
        id,
        plan_id,
        repository_id,
        agent_id,
        status,
        finished_at_gt,
        finished_at_lt,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if id is not None:
            _query_params.append(("id", id))

        if plan_id is not None:
            _query_params.append(("plan_id", plan_id))

        if repository_id is not None:
            _query_params.append(("repository_id", repository_id))

        if agent_id is not None:
            _query_params.append(("agent_id", agent_id))

        if status is not None:
            _query_params.append(("status", status.value))

        if finished_at_gt is not None:
            if isinstance(finished_at_gt, datetime):
                _query_params.append(
                    ("finished_at_gt", finished_at_gt.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_gt", finished_at_gt))

        if finished_at_lt is not None:
            if isinstance(finished_at_lt, datetime):
                _query_params.append(
                    ("finished_at_lt", finished_at_lt.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_lt", finished_at_lt))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/history/latest/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_all_restore_history_plan_restore_history_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRestorePlanRun:
        """List All Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_restore_history_plan_restore_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_all_restore_history_plan_restore_history_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRestorePlanRun]:
        """List All Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_restore_history_plan_restore_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_all_restore_history_plan_restore_history_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        plan_id: Optional[UUID] = None,
        repository_id: Optional[UUID] = None,
        agent_id: Optional[UUID] = None,
        status: Optional[Any] = None,
        finished_at_gt: Optional[datetime] = None,
        finished_at_lt: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Restore History


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param plan_id:
        :type plan_id: UUID
        :param repository_id:
        :type repository_id: UUID
        :param agent_id:
        :type agent_id: UUID
        :param status:
        :type status: PlanStatus
        :param finished_at_gt:
        :type finished_at_gt: datetime
        :param finished_at_lt:
        :type finished_at_lt: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_all_restore_history_plan_restore_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            plan_id=plan_id,
            repository_id=repository_id,
            agent_id=agent_id,
            status=status,
            finished_at_gt=finished_at_gt,
            finished_at_lt=finished_at_lt,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_all_restore_history_plan_restore_history_get_serialize(
        self,
        page,
        per_page,
        order_by,
        id,
        plan_id,
        repository_id,
        agent_id,
        status,
        finished_at_gt,
        finished_at_lt,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if id is not None:
            _query_params.append(("id", id))

        if plan_id is not None:
            _query_params.append(("plan_id", plan_id))

        if repository_id is not None:
            _query_params.append(("repository_id", repository_id))

        if agent_id is not None:
            _query_params.append(("agent_id", agent_id))

        if status is not None:
            _query_params.append(("status", status.value))

        if finished_at_gt is not None:
            if isinstance(finished_at_gt, datetime):
                _query_params.append(
                    ("finished_at_gt", finished_at_gt.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_gt", finished_at_gt))

        if finished_at_lt is not None:
            if isinstance(finished_at_lt, datetime):
                _query_params.append(
                    ("finished_at_lt", finished_at_lt.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_lt", finished_at_lt))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/history/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_file_restore_history_plan_restore_file_plan_id_history_get(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRestorePlanRun:
        """List File Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_history_plan_restore_file_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_file_restore_history_plan_restore_file_plan_id_history_get_with_http_info(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRestorePlanRun]:
        """List File Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_history_plan_restore_file_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_file_restore_history_plan_restore_file_plan_id_history_get_without_preload_content(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List File Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_history_plan_restore_file_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_file_restore_history_plan_restore_file_plan_id_history_get_serialize(
        self,
        plan_id,
        page,
        per_page,
        order_by,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/file/{plan_id}/history/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_file_restore_plans_plan_restore_file_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageFileRestorePlan:
        """List File Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_plans_plan_restore_file_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageFileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_file_restore_plans_plan_restore_file_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageFileRestorePlan]:
        """List File Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_plans_plan_restore_file_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageFileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_file_restore_plans_plan_restore_file_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List File Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_file_restore_plans_plan_restore_file_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageFileRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_file_restore_plans_plan_restore_file_get_serialize(
        self,
        page,
        per_page,
        order_by,
        id,
        name,
        repo_id,
        schedule_enabled,
        linked_agents_contains,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "linked_agents_contains": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if id is not None:
            _query_params.append(("id", id))

        if name is not None:
            _query_params.append(("name", name))

        if repo_id is not None:
            _query_params.append(("repo_id", repo_id))

        if schedule_enabled is not None:
            _query_params.append(("schedule_enabled", schedule_enabled))

        if linked_agents_contains is not None:
            _query_params.append(("linked_agents_contains", linked_agents_contains))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/file/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_image_restore_history_plan_restore_image_plan_id_history_get(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRestorePlanRun:
        """List Image Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_history_plan_restore_image_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_image_restore_history_plan_restore_image_plan_id_history_get_with_http_info(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRestorePlanRun]:
        """List Image Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_history_plan_restore_image_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_image_restore_history_plan_restore_image_plan_id_history_get_without_preload_content(
        self,
        plan_id: UUID,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Image Restore History


        :param plan_id: (required)
        :type plan_id: UUID
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_history_plan_restore_image_plan_id_history_get_serialize(
            plan_id=plan_id,
            page=page,
            per_page=per_page,
            order_by=order_by,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRestorePlanRun",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_image_restore_history_plan_restore_image_plan_id_history_get_serialize(
        self,
        plan_id,
        page,
        per_page,
        order_by,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/image/{plan_id}/history/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_image_restore_plans_plan_restore_image_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageImageRestorePlan:
        """List Image Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_plans_plan_restore_image_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_image_restore_plans_plan_restore_image_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageImageRestorePlan]:
        """List Image Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_plans_plan_restore_image_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_image_restore_plans_plan_restore_image_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[UUID] = None,
        name: Optional[Any] = None,
        repo_id: Optional[UUID] = None,
        schedule_enabled: Optional[StrictBool] = None,
        linked_agents_contains: Optional[List[UUID]] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Image Restore Plans


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: UUID
        :param name:
        :type name: str
        :param repo_id:
        :type repo_id: UUID
        :param schedule_enabled:
        :type schedule_enabled: bool
        :param linked_agents_contains:
        :type linked_agents_contains: List[UUID]
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_image_restore_plans_plan_restore_image_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            repo_id=repo_id,
            schedule_enabled=schedule_enabled,
            linked_agents_contains=linked_agents_contains,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageImageRestorePlan",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_image_restore_plans_plan_restore_image_get_serialize(
        self,
        page,
        per_page,
        order_by,
        id,
        name,
        repo_id,
        schedule_enabled,
        linked_agents_contains,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "linked_agents_contains": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if id is not None:
            _query_params.append(("id", id))

        if name is not None:
            _query_params.append(("name", name))

        if repo_id is not None:
            _query_params.append(("repo_id", repo_id))

        if schedule_enabled is not None:
            _query_params.append(("schedule_enabled", schedule_enabled))

        if linked_agents_contains is not None:
            _query_params.append(("linked_agents_contains", linked_agents_contains))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/plan/restore/image/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_with_http_info(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_without_preload_content(
        self,
        plan_id: UUID,
        agent_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove Restore Plan Agent


        :param plan_id: (required)
        :type plan_id: UUID
        :param agent_id: (required)
        :type agent_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_serialize(
            plan_id=plan_id,
            agent_id=agent_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post_serialize(
        self,
        plan_id,
        agent_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        if agent_id is not None:
            _path_params["agent_id"] = agent_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/{plan_id}/remove-agent/{agent_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_with_http_info(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_without_preload_content(
        self,
        plan_id: UUID,
        schedule_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove Restore Plan Schedule


        :param plan_id: (required)
        :type plan_id: UUID
        :param schedule_id: (required)
        :type schedule_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_serialize(
            plan_id=plan_id,
            schedule_id=schedule_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post_serialize(
        self,
        plan_id,
        schedule_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        if schedule_id is not None:
            _path_params["schedule_id"] = schedule_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/plan/restore/{plan_id}/remove-schedule/{schedule_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_file_restore_plans_plan_restore_file_plan_id_put(
        self,
        plan_id: UUID,
        file_restore_plan_update: FileRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param file_restore_plan_update: (required)
        :type file_restore_plan_update: FileRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_file_restore_plans_plan_restore_file_plan_id_put_serialize(
            plan_id=plan_id,
            file_restore_plan_update=file_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_file_restore_plans_plan_restore_file_plan_id_put_with_http_info(
        self,
        plan_id: UUID,
        file_restore_plan_update: FileRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param file_restore_plan_update: (required)
        :type file_restore_plan_update: FileRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_file_restore_plans_plan_restore_file_plan_id_put_serialize(
            plan_id=plan_id,
            file_restore_plan_update=file_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_file_restore_plans_plan_restore_file_plan_id_put_without_preload_content(
        self,
        plan_id: UUID,
        file_restore_plan_update: FileRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update File Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param file_restore_plan_update: (required)
        :type file_restore_plan_update: FileRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_file_restore_plans_plan_restore_file_plan_id_put_serialize(
            plan_id=plan_id,
            file_restore_plan_update=file_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_file_restore_plans_plan_restore_file_plan_id_put_serialize(
        self,
        plan_id,
        file_restore_plan_update,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if file_restore_plan_update is not None:
            _body_params = file_restore_plan_update

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/plan/restore/file/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_image_restore_plans_plan_restore_image_plan_id_put(
        self,
        plan_id: UUID,
        image_restore_plan_update: ImageRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param image_restore_plan_update: (required)
        :type image_restore_plan_update: ImageRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_image_restore_plans_plan_restore_image_plan_id_put_serialize(
            plan_id=plan_id,
            image_restore_plan_update=image_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_image_restore_plans_plan_restore_image_plan_id_put_with_http_info(
        self,
        plan_id: UUID,
        image_restore_plan_update: ImageRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param image_restore_plan_update: (required)
        :type image_restore_plan_update: ImageRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_image_restore_plans_plan_restore_image_plan_id_put_serialize(
            plan_id=plan_id,
            image_restore_plan_update=image_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_image_restore_plans_plan_restore_image_plan_id_put_without_preload_content(
        self,
        plan_id: UUID,
        image_restore_plan_update: ImageRestorePlanUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Image Restore Plans


        :param plan_id: (required)
        :type plan_id: UUID
        :param image_restore_plan_update: (required)
        :type image_restore_plan_update: ImageRestorePlanUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_image_restore_plans_plan_restore_image_plan_id_put_serialize(
            plan_id=plan_id,
            image_restore_plan_update=image_restore_plan_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_image_restore_plans_plan_restore_image_plan_id_put_serialize(
        self,
        plan_id,
        image_restore_plan_update,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plan_id is not None:
            _path_params["plan_id"] = plan_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if image_restore_plan_update is not None:
            _body_params = image_restore_plan_update

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/plan/restore/image/{plan_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
