"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr, field_validator
from typing import Any, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from cybee_sdk.api.models.maintenance_type import MaintenanceType
from cybee_sdk.api.models.page_repository import PageRepository
from cybee_sdk.api.models.page_repository_checks import PageRepositoryChecks
from cybee_sdk.api.models.page_repository_prunes import PageRepositoryPrunes
from cybee_sdk.api.models.page_repository_stats import PageRepositoryStats
from cybee_sdk.api.models.repository import Repository
from cybee_sdk.api.models.repository_create import RepositoryCreate
from cybee_sdk.api.models.repository_maintenance import RepositoryMaintenance
from cybee_sdk.api.models.repository_maintenance_create_update import RepositoryMaintenanceCreateUpdate
from cybee_sdk.api.models.repository_update import RepositoryUpdate

from cybee_sdk.api.api_client import ApiClient, RequestSerialized
from cybee_sdk.api.api_response import ApiResponse
from cybee_sdk.api.rest import RESTResponseType


class StorageRepositoryApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_repository_storage_repository_post(
        self,
        repository_create: RepositoryCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create Repository


        :param repository_create: (required)
        :type repository_create: RepositoryCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_repository_storage_repository_post_serialize(
            repository_create=repository_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_repository_storage_repository_post_with_http_info(
        self,
        repository_create: RepositoryCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create Repository


        :param repository_create: (required)
        :type repository_create: RepositoryCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_repository_storage_repository_post_serialize(
            repository_create=repository_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_repository_storage_repository_post_without_preload_content(
        self,
        repository_create: RepositoryCreate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Repository


        :param repository_create: (required)
        :type repository_create: RepositoryCreate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_repository_storage_repository_post_serialize(
            repository_create=repository_create,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_repository_storage_repository_post_serialize(
        self,
        repository_create,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if repository_create is not None:
            _body_params = repository_create

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/storage/repository/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_repository_storage_repository_repository_id_delete(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_repository_storage_repository_repository_id_delete_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_repository_storage_repository_repository_id_delete_with_http_info(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_repository_storage_repository_repository_id_delete_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_repository_storage_repository_repository_id_delete_without_preload_content(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_repository_storage_repository_repository_id_delete_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_repository_storage_repository_repository_id_delete_serialize(
        self,
        repository_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/storage/repository/{repository_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Execute Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_with_http_info(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Execute Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_without_preload_content(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get_serialize(
        self,
        maintenance_type,
        repository_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if maintenance_type is not None:
            _path_params["maintenance_type"] = maintenance_type.value
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/{repository_id}/maintenance/{maintenance_type}/execute/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_repository_maintenance_storage_repository_repository_id_maintenance_get(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryMaintenance:
        """Get Repository Maintenance


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_maintenance_storage_repository_repository_id_maintenance_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_repository_maintenance_storage_repository_repository_id_maintenance_get_with_http_info(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryMaintenance]:
        """Get Repository Maintenance


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_maintenance_storage_repository_repository_id_maintenance_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_repository_maintenance_storage_repository_repository_id_maintenance_get_without_preload_content(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Repository Maintenance


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_maintenance_storage_repository_repository_id_maintenance_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_repository_maintenance_storage_repository_repository_id_maintenance_get_serialize(
        self,
        repository_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/{repository_id}/maintenance/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_repository_storage_repository_repository_id_get(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Repository:
        """Get Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_storage_repository_repository_id_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Repository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_repository_storage_repository_repository_id_get_with_http_info(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Repository]:
        """Get Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_storage_repository_repository_id_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Repository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_repository_storage_repository_repository_id_get_without_preload_content(
        self,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_repository_storage_repository_repository_id_get_serialize(
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "Repository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_repository_storage_repository_repository_id_get_serialize(
        self,
        repository_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/{repository_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_repository_checks_storage_repository_check_history_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRepositoryChecks:
        """List Repository Checks


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_checks_storage_repository_check_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryChecks",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_repository_checks_storage_repository_check_history_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRepositoryChecks]:
        """List Repository Checks


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_checks_storage_repository_check_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryChecks",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_repository_checks_storage_repository_check_history_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Repository Checks


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_checks_storage_repository_check_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryChecks",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_repository_checks_storage_repository_check_history_get_serialize(
        self,
        page,
        per_page,
        order_by,
        repository_id,
        started_at_ge,
        started_at_le,
        finished_at_ge,
        finished_at_le,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "repository_id": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if repository_id is not None:
            _query_params.append(("repository_id", repository_id))

        if started_at_ge is not None:
            if isinstance(started_at_ge, datetime):
                _query_params.append(
                    ("started_at_ge", started_at_ge.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("started_at_ge", started_at_ge))

        if started_at_le is not None:
            if isinstance(started_at_le, datetime):
                _query_params.append(
                    ("started_at_le", started_at_le.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("started_at_le", started_at_le))

        if finished_at_ge is not None:
            if isinstance(finished_at_ge, datetime):
                _query_params.append(
                    ("finished_at_ge", finished_at_ge.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_ge", finished_at_ge))

        if finished_at_le is not None:
            if isinstance(finished_at_le, datetime):
                _query_params.append(
                    ("finished_at_le", finished_at_le.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_le", finished_at_le))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/check-history/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_repository_prunes_storage_repository_prune_history_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRepositoryPrunes:
        """List Repository Prunes


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_prunes_storage_repository_prune_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryPrunes",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_repository_prunes_storage_repository_prune_history_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRepositoryPrunes]:
        """List Repository Prunes


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_prunes_storage_repository_prune_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryPrunes",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_repository_prunes_storage_repository_prune_history_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        started_at_ge: Optional[datetime] = None,
        started_at_le: Optional[datetime] = None,
        finished_at_ge: Optional[datetime] = None,
        finished_at_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Repository Prunes


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param started_at_ge:
        :type started_at_ge: datetime
        :param started_at_le:
        :type started_at_le: datetime
        :param finished_at_ge:
        :type finished_at_ge: datetime
        :param finished_at_le:
        :type finished_at_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_prunes_storage_repository_prune_history_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            started_at_ge=started_at_ge,
            started_at_le=started_at_le,
            finished_at_ge=finished_at_ge,
            finished_at_le=finished_at_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryPrunes",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_repository_prunes_storage_repository_prune_history_get_serialize(
        self,
        page,
        per_page,
        order_by,
        repository_id,
        started_at_ge,
        started_at_le,
        finished_at_ge,
        finished_at_le,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "repository_id": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if repository_id is not None:
            _query_params.append(("repository_id", repository_id))

        if started_at_ge is not None:
            if isinstance(started_at_ge, datetime):
                _query_params.append(
                    ("started_at_ge", started_at_ge.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("started_at_ge", started_at_ge))

        if started_at_le is not None:
            if isinstance(started_at_le, datetime):
                _query_params.append(
                    ("started_at_le", started_at_le.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("started_at_le", started_at_le))

        if finished_at_ge is not None:
            if isinstance(finished_at_ge, datetime):
                _query_params.append(
                    ("finished_at_ge", finished_at_ge.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_ge", finished_at_ge))

        if finished_at_le is not None:
            if isinstance(finished_at_le, datetime):
                _query_params.append(
                    ("finished_at_le", finished_at_le.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("finished_at_le", finished_at_le))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/prune-history/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_repository_stats_storage_repository_stats_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        mode: Optional[Any] = None,
        timestamp_ge: Optional[datetime] = None,
        timestamp_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRepositoryStats:
        """List Repository Stats


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param mode:
        :type mode: ResticStatsModeEnum
        :param timestamp_ge:
        :type timestamp_ge: datetime
        :param timestamp_le:
        :type timestamp_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_stats_storage_repository_stats_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            mode=mode,
            timestamp_ge=timestamp_ge,
            timestamp_le=timestamp_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryStats",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_repository_stats_storage_repository_stats_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        mode: Optional[Any] = None,
        timestamp_ge: Optional[datetime] = None,
        timestamp_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRepositoryStats]:
        """List Repository Stats


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param mode:
        :type mode: ResticStatsModeEnum
        :param timestamp_ge:
        :type timestamp_ge: datetime
        :param timestamp_le:
        :type timestamp_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_stats_storage_repository_stats_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            mode=mode,
            timestamp_ge=timestamp_ge,
            timestamp_le=timestamp_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryStats",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_repository_stats_storage_repository_stats_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        repository_id: Optional[List[UUID]] = None,
        mode: Optional[Any] = None,
        timestamp_ge: Optional[datetime] = None,
        timestamp_le: Optional[datetime] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Repository Stats


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param repository_id:
        :type repository_id: List[UUID]
        :param mode:
        :type mode: ResticStatsModeEnum
        :param timestamp_ge:
        :type timestamp_ge: datetime
        :param timestamp_le:
        :type timestamp_le: datetime
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_stats_storage_repository_stats_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            repository_id=repository_id,
            mode=mode,
            timestamp_ge=timestamp_ge,
            timestamp_le=timestamp_le,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepositoryStats",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_repository_stats_storage_repository_stats_get_serialize(
        self,
        page,
        per_page,
        order_by,
        repository_id,
        mode,
        timestamp_ge,
        timestamp_le,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "repository_id": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if repository_id is not None:
            _query_params.append(("repository_id", repository_id))

        if mode is not None:
            _query_params.append(("mode", mode.value))

        if timestamp_ge is not None:
            if isinstance(timestamp_ge, datetime):
                _query_params.append(
                    ("timestamp_ge", timestamp_ge.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("timestamp_ge", timestamp_ge))

        if timestamp_le is not None:
            if isinstance(timestamp_le, datetime):
                _query_params.append(
                    ("timestamp_le", timestamp_le.strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("timestamp_le", timestamp_le))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/stats/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_repository_storage_repository_get(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[List[UUID]] = None,
        name: Optional[Any] = None,
        slug: Optional[Any] = None,
        status: Optional[Any] = None,
        storage_destination_id: Optional[List[UUID]] = None,
        version: Optional[Any] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageRepository:
        """List Repository


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: List[UUID]
        :param name:
        :type name: str
        :param slug:
        :type slug: str
        :param status:
        :type status: RepositoryStatusEnum
        :param storage_destination_id:
        :type storage_destination_id: List[UUID]
        :param version:
        :type version: ResticVersionEnum
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_storage_repository_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            slug=slug,
            status=status,
            storage_destination_id=storage_destination_id,
            version=version,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_repository_storage_repository_get_with_http_info(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[List[UUID]] = None,
        name: Optional[Any] = None,
        slug: Optional[Any] = None,
        status: Optional[Any] = None,
        storage_destination_id: Optional[List[UUID]] = None,
        version: Optional[Any] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageRepository]:
        """List Repository


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: List[UUID]
        :param name:
        :type name: str
        :param slug:
        :type slug: str
        :param status:
        :type status: RepositoryStatusEnum
        :param storage_destination_id:
        :type storage_destination_id: List[UUID]
        :param version:
        :type version: ResticVersionEnum
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_storage_repository_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            slug=slug,
            status=status,
            storage_destination_id=storage_destination_id,
            version=version,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_repository_storage_repository_get_without_preload_content(
        self,
        page: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        per_page: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None,
        order_by: Optional[List[StrictStr]] = None,
        id: Optional[List[UUID]] = None,
        name: Optional[Any] = None,
        slug: Optional[Any] = None,
        status: Optional[Any] = None,
        storage_destination_id: Optional[List[UUID]] = None,
        version: Optional[Any] = None,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Repository


        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param order_by:
        :type order_by: List[str]
        :param id:
        :type id: List[UUID]
        :param name:
        :type name: str
        :param slug:
        :type slug: str
        :param status:
        :type status: RepositoryStatusEnum
        :param storage_destination_id:
        :type storage_destination_id: List[UUID]
        :param version:
        :type version: ResticVersionEnum
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_repository_storage_repository_get_serialize(
            page=page,
            per_page=per_page,
            order_by=order_by,
            id=id,
            name=name,
            slug=slug,
            status=status,
            storage_destination_id=storage_destination_id,
            version=version,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PageRepository",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_repository_storage_repository_get_serialize(
        self,
        page,
        per_page,
        order_by,
        id,
        name,
        slug,
        status,
        storage_destination_id,
        version,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "order_by": "multi",
            "id": "multi",
            "storage_destination_id": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            _query_params.append(("page", page))

        if per_page is not None:
            _query_params.append(("per_page", per_page))

        if order_by is not None:
            _query_params.append(("order_by", order_by))

        if id is not None:
            _query_params.append(("id", id))

        if name is not None:
            _query_params.append(("name", name))

        if slug is not None:
            _query_params.append(("slug", slug))

        if status is not None:
            _query_params.append(("status", status.value))

        if storage_destination_id is not None:
            _query_params.append(("storage_destination_id", storage_destination_id))

        if version is not None:
            _query_params.append(("version", version.value))

        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/storage/repository/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryMaintenance:
        """Set Repository Maintenance

        Modifie ou créé un paramétrage de maintenance  - **maintenance_type**: Peut être \"check\" ou \"prune\", voir la ressource **MaintenanceType** - **schedule**: Une planification au format crontab, par exemple \"0 0 * * *\" pour une tâche quotidienne à minuit

        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_maintenance_create_update: (required)
        :type repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            repository_maintenance_create_update=repository_maintenance_create_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_with_http_info(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryMaintenance]:
        """Set Repository Maintenance

        Modifie ou créé un paramétrage de maintenance  - **maintenance_type**: Peut être \"check\" ou \"prune\", voir la ressource **MaintenanceType** - **schedule**: Une planification au format crontab, par exemple \"0 0 * * *\" pour une tâche quotidienne à minuit

        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_maintenance_create_update: (required)
        :type repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            repository_maintenance_create_update=repository_maintenance_create_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_without_preload_content(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set Repository Maintenance

        Modifie ou créé un paramétrage de maintenance  - **maintenance_type**: Peut être \"check\" ou \"prune\", voir la ressource **MaintenanceType** - **schedule**: Une planification au format crontab, par exemple \"0 0 * * *\" pour une tâche quotidienne à minuit

        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_maintenance_create_update: (required)
        :type repository_maintenance_create_update: RepositoryMaintenanceCreateUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            repository_maintenance_create_update=repository_maintenance_create_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "RepositoryMaintenance",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post_serialize(
        self,
        maintenance_type,
        repository_id,
        repository_maintenance_create_update,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if maintenance_type is not None:
            _path_params["maintenance_type"] = maintenance_type.value
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if repository_maintenance_create_update is not None:
            _body_params = repository_maintenance_create_update

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/storage/repository/{repository_id}/maintenance/{maintenance_type}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Unset Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_with_http_info(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Unset Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_without_preload_content(
        self,
        maintenance_type: MaintenanceType,
        repository_id: UUID,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unset Repository Maintenance


        :param maintenance_type: (required)
        :type maintenance_type: MaintenanceType
        :param repository_id: (required)
        :type repository_id: UUID
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_serialize(
            maintenance_type=maintenance_type,
            repository_id=repository_id,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete_serialize(
        self,
        maintenance_type,
        repository_id,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if maintenance_type is not None:
            _path_params["maintenance_type"] = maintenance_type.value
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/storage/repository/{repository_id}/maintenance/{maintenance_type}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_repository_storage_repository_repository_id_patch(
        self,
        repository_id: UUID,
        repository_update: RepositoryUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_update: (required)
        :type repository_update: RepositoryUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_repository_storage_repository_repository_id_patch_serialize(
            repository_id=repository_id,
            repository_update=repository_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_repository_storage_repository_repository_id_patch_with_http_info(
        self,
        repository_id: UUID,
        repository_update: RepositoryUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_update: (required)
        :type repository_update: RepositoryUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_repository_storage_repository_repository_id_patch_serialize(
            repository_id=repository_id,
            repository_update=repository_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_repository_storage_repository_repository_id_patch_without_preload_content(
        self,
        repository_id: UUID,
        repository_update: RepositoryUpdate,
        cbe_user_org_id: Optional[Annotated[str, Field(strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Repository


        :param repository_id: (required)
        :type repository_id: UUID
        :param repository_update: (required)
        :type repository_update: RepositoryUpdate
        :param cbe_user_org_id:
        :type cbe_user_org_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_repository_storage_repository_repository_id_patch_serialize(
            repository_id=repository_id,
            repository_update=repository_update,
            cbe_user_org_id=cbe_user_org_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_repository_storage_repository_repository_id_patch_serialize(
        self,
        repository_id,
        repository_update,
        cbe_user_org_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if repository_id is not None:
            _path_params["repository_id"] = repository_id
        # process the query parameters
        # process the header parameters
        if cbe_user_org_id is not None:
            _header_params["cbe-user-org-id"] = cbe_user_org_id
        # process the form parameters
        # process the body parameter
        if repository_update is not None:
            _body_params = repository_update

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["ZitadelWebAuthorizationBearer", "BearerToken"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/storage/repository/{repository_id}/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
