# cybee_sdk.api.AgentsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**approve_agent_agent_agent_id_approve_post**](AgentsApi.md#approve_agent_agent_agent_id_approve_post) | **POST** /agent/{agent_id}/approve/ | Approve Agent
[**delete_agent_agent_agent_id_delete**](AgentsApi.md#delete_agent_agent_agent_id_delete) | **DELETE** /agent/{agent_id}/ | Delete Agent
[**get_agent_agent_unregistered_get**](AgentsApi.md#get_agent_agent_unregistered_get) | **GET** /agent/unregistered/ | Get Agent
[**list_agent_agent_get**](AgentsApi.md#list_agent_agent_get) | **GET** /agent/ | List Agent
[**update_agent_agent_agent_id_put**](AgentsApi.md#update_agent_agent_agent_id_put) | **PUT** /agent/{agent_id}/ | Update Agent


# **approve_agent_agent_agent_id_approve_post**
> approve_agent_agent_agent_id_approve_post(agent_id, cbe_user_org_id=cbe_user_org_id)

Approve Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Approve Agent
        api_instance.approve_agent_agent_agent_id_approve_post(agent_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling AgentsApi->approve_agent_agent_agent_id_approve_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_agent_agent_agent_id_delete**
> object delete_agent_agent_agent_id_delete(agent_id, cbe_user_org_id=cbe_user_org_id)

Delete Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Agent
        api_response = api_instance.delete_agent_agent_agent_id_delete(agent_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of AgentsApi->delete_agent_agent_agent_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->delete_agent_agent_agent_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_agent_agent_unregistered_get**
> PageUnregisteredAgentInfo get_agent_agent_unregistered_get(page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)

Get Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_unregistered_agent_info import PageUnregisteredAgentInfo
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Agent
        api_response = api_instance.get_agent_agent_unregistered_get(page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)
        print("The response of AgentsApi->get_agent_agent_unregistered_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->get_agent_agent_unregistered_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageUnregisteredAgentInfo**](PageUnregisteredAgentInfo.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_agent_agent_get**
> PageAgentInfo list_agent_agent_get(page=page, per_page=per_page, order_by=order_by, id=id, machine_id=machine_id, custom_name=custom_name, host_name=host_name, online=online, cbe_user_org_id=cbe_user_org_id)

List Agent

Fetches the list of all known and registered agents

Most of the filters are able to handle multiple entries.

For multiple data in the same field, values are combined with an **OR**

For data in different fields, fields are combined with an **AND**

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_agent_info import PageAgentInfo
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = None # List[UUID] |  (optional)
    machine_id = ['machine_id_example'] # List[Optional[str]] |  (optional)
    custom_name = ['custom_name_example'] # List[str] |  (optional)
    host_name = ['host_name_example'] # List[str] |  (optional)
    online = True # bool |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Agent
        api_response = api_instance.list_agent_agent_get(page=page, per_page=per_page, order_by=order_by, id=id, machine_id=machine_id, custom_name=custom_name, host_name=host_name, online=online, cbe_user_org_id=cbe_user_org_id)
        print("The response of AgentsApi->list_agent_agent_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->list_agent_agent_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **machine_id** | [**List[Optional[str]]**](str.md)|  | [optional] 
 **custom_name** | [**List[str]**](str.md)|  | [optional] 
 **host_name** | [**List[str]**](str.md)|  | [optional] 
 **online** | **bool**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageAgentInfo**](PageAgentInfo.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_agent_agent_agent_id_put**
> object update_agent_agent_agent_id_put(agent_id, agent_update, cbe_user_org_id=cbe_user_org_id)

Update Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.agent_update import AgentUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    agent_update = cybee_sdk.api.AgentUpdate() # AgentUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Agent
        api_response = api_instance.update_agent_agent_agent_id_put(agent_id, agent_update, cbe_user_org_id=cbe_user_org_id)
        print("The response of AgentsApi->update_agent_agent_agent_id_put:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->update_agent_agent_agent_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **UUID**|  | 
 **agent_update** | [**AgentUpdate**](AgentUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

