# cybee_sdk.api.CmdbApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**list_cmdb_items_cmdb_machines_get**](CmdbApi.md#list_cmdb_items_cmdb_machines_get) | **GET** /cmdb/machines/ | List Cmdb Items
[**list_historical_cmdb_items_cmdb_machines_historical_get**](CmdbApi.md#list_historical_cmdb_items_cmdb_machines_historical_get) | **GET** /cmdb/machines/historical/ | List Historical Cmdb Items


# **list_cmdb_items_cmdb_machines_get**
> PageMachine list_cmdb_items_cmdb_machines_get(page=page, per_page=per_page, order_by=order_by, machine_id=machine_id, host_name=host_name, cbe_user_org_id=cbe_user_org_id)

List Cmdb Items

List machines infos known by the CMDB component.

For now, apart from machine_id (which is the same value as in the `Agent`-related API),
there is no possibility of filtering over nested values.

Each item has dates representing infos on the given machine :

- created_at: Date when the machine appeared in the system.
- changed_at: Most recent change of the machine info.
- updated_at: Last time we recieved something from this machine.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_machine import PageMachine
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.CmdbApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    machine_id = 'machine_id_example' # str |  (optional)
    host_name = 'host_name_example' # str |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Cmdb Items
        api_response = api_instance.list_cmdb_items_cmdb_machines_get(page=page, per_page=per_page, order_by=order_by, machine_id=machine_id, host_name=host_name, cbe_user_org_id=cbe_user_org_id)
        print("The response of CmdbApi->list_cmdb_items_cmdb_machines_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CmdbApi->list_cmdb_items_cmdb_machines_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **machine_id** | [**str**](.md)|  | [optional] 
 **host_name** | [**str**](.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageMachine**](PageMachine.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_historical_cmdb_items_cmdb_machines_historical_get**
> PageHistoricalMachine list_historical_cmdb_items_cmdb_machines_historical_get(page=page, per_page=per_page, order_by=order_by, machine_id=machine_id, host_name=host_name, cbe_user_org_id=cbe_user_org_id)

List Historical Cmdb Items

List machines historical infos known by the CMDB component.

For now, apart from machine_id (which is the same value as in the `Agent`-related API),
there is no possibility of filtering over nested values.

Each historical item is valid between started_at value, up until updated_at.

- started_at represents the first time we got this snapshot of the machine
- updated_at represents the last time we got these informations, and is continually updated while
the info are valid.

When the machine changes and the system detects it, a new historical item is
created with a started_at at "now", and the older entry is not modified anymore.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_historical_machine import PageHistoricalMachine
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.CmdbApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    machine_id = 'machine_id_example' # str |  (optional)
    host_name = 'host_name_example' # str |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Historical Cmdb Items
        api_response = api_instance.list_historical_cmdb_items_cmdb_machines_historical_get(page=page, per_page=per_page, order_by=order_by, machine_id=machine_id, host_name=host_name, cbe_user_org_id=cbe_user_org_id)
        print("The response of CmdbApi->list_historical_cmdb_items_cmdb_machines_historical_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CmdbApi->list_historical_cmdb_items_cmdb_machines_historical_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **machine_id** | [**str**](.md)|  | [optional] 
 **host_name** | [**str**](.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageHistoricalMachine**](PageHistoricalMachine.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

