# FileBackupPlan


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **UUID** |  | 
**name** | **str** |  | 
**repo_id** | **UUID** |  | 
**config** | [**ResticBackupOutput**](ResticBackupOutput.md) |  | 
**retention_settings** | [**RetentionSettings**](RetentionSettings.md) |  | [optional] 
**schedule_enabled** | **bool** |  | [optional] [default to False]
**schedule_configs** | **List[UUID]** |  | [optional] 
**last_executed** | **datetime** |  | [optional] 
**timestamps** | [**TimeStamps**](TimeStamps.md) |  | 
**affected_agents** | **List[UUID]** |  | [optional] [default to []]
**pre_script** | [**PrePostRunScript**](PrePostRunScript.md) |  | [optional] 
**post_script** | [**PrePostRunScript**](PrePostRunScript.md) |  | [optional] 

## Example

```python
from cybee_sdk.api.models.file_backup_plan import FileBackupPlan

# TODO update the JSON string below
json = "{}"
# create an instance of FileBackupPlan from a JSON string
file_backup_plan_instance = FileBackupPlan.from_json(json)
# print the JSON string representation of the object
print(FileBackupPlan.to_json())

# convert the object into a dict
file_backup_plan_dict = file_backup_plan_instance.to_dict()
# create an instance of FileBackupPlan from a dict
file_backup_plan_from_dict = FileBackupPlan.from_dict(file_backup_plan_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


