# MassStorage

A raw space generaly backed by a physical drive. It could also be the representation of a pool of drives or RAID. That is the space on which you find the partition table.  In a image backup / restoration context, it is the lower emptity you may list and on which you can select what to backup / restore.  ## Fields definition:  - device_path: The (System depend) logical path to access this raw space. - support: The logical or physical represetentation of the abstraction given by this object.   It's generaly a physical drive or a RAID but may also be composed by virtual raw spaces. - largest_free_space: The largest contigous space available on this storage.   It can be seen as the biggest size usable for a new partition.

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**storage_format** | [**StorageFormat**](StorageFormat.md) |  | 
**id** | **str** |  | 
**device_path** | **str** |  | 
**name** | **str** |  | 
**total_size** | **int** |  | 
**largest_free_space** | **int** |  | 
**support** | [**PhyDrive**](PhyDrive.md) |  | [optional] 
**content** | [**List[Partition]**](Partition.md) |  | [optional] 

## Example

```python
from cybee_sdk.api.models.mass_storage import MassStorage

# TODO update the JSON string below
json = "{}"
# create an instance of MassStorage from a JSON string
mass_storage_instance = MassStorage.from_json(json)
# print the JSON string representation of the object
print(MassStorage.to_json())

# convert the object into a dict
mass_storage_dict = mass_storage_instance.to_dict()
# create an instance of MassStorage from a dict
mass_storage_from_dict = MassStorage.from_dict(mass_storage_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


