# cybee_sdk.api.PlansBackupApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**](PlansBackupApi.md#assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/assign-agent/{agent_id}/ | Assign Backup Plan Agent
[**assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**](PlansBackupApi.md#assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/assign-schedule/{schedule_id}/ | Assign Backup Plan Schedule
[**create_file_backup_plans_plan_backup_file_post**](PlansBackupApi.md#create_file_backup_plans_plan_backup_file_post) | **POST** /plan/backup/file/ | Create File Backup Plans
[**create_image_backup_plans_plan_backup_image_post**](PlansBackupApi.md#create_image_backup_plans_plan_backup_image_post) | **POST** /plan/backup/image/ | Create Image Backup Plans
[**delete_file_backup_plans_plan_backup_file_plan_id_delete**](PlansBackupApi.md#delete_file_backup_plans_plan_backup_file_plan_id_delete) | **DELETE** /plan/backup/file/{plan_id}/ | Delete File Backup Plans
[**delete_image_backup_plans_plan_backup_image_plan_id_delete**](PlansBackupApi.md#delete_image_backup_plans_plan_backup_image_plan_id_delete) | **DELETE** /plan/backup/image/{plan_id}/ | Delete Image Backup Plans
[**execute_file_backup_plan_plan_backup_file_plan_id_execute_post**](PlansBackupApi.md#execute_file_backup_plan_plan_backup_file_plan_id_execute_post) | **POST** /plan/backup/file/{plan_id}/execute/ | Execute File Backup Plan
[**execute_image_backup_plan_plan_backup_image_plan_id_execute_post**](PlansBackupApi.md#execute_image_backup_plan_plan_backup_image_plan_id_execute_post) | **POST** /plan/backup/image/{plan_id}/execute/ | Execute Image Backup Plan
[**get_file_backup_plan_plan_backup_file_plan_id_get**](PlansBackupApi.md#get_file_backup_plan_plan_backup_file_plan_id_get) | **GET** /plan/backup/file/{plan_id}/ | Get File Backup Plan
[**get_image_backup_plan_plan_backup_image_plan_id_get**](PlansBackupApi.md#get_image_backup_plan_plan_backup_image_plan_id_get) | **GET** /plan/backup/image/{plan_id}/ | Get Image Backup Plan
[**get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get**](PlansBackupApi.md#get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get) | **GET** /plan/backup/backup/run/{plan_run_id}/status/ | Get Running Plan Status
[**list_all_backup_history_plan_backup_history_get**](PlansBackupApi.md#list_all_backup_history_plan_backup_history_get) | **GET** /plan/backup/history/ | List All Backup History
[**list_all_latest_backup_history_plan_backup_history_latest_get**](PlansBackupApi.md#list_all_latest_backup_history_plan_backup_history_latest_get) | **GET** /plan/backup/history/latest/ | List All Latest Backup History
[**list_file_backup_history_plan_backup_file_plan_id_history_get**](PlansBackupApi.md#list_file_backup_history_plan_backup_file_plan_id_history_get) | **GET** /plan/backup/file/{plan_id}/history/ | List File Backup History
[**list_file_backup_plans_plan_backup_file_get**](PlansBackupApi.md#list_file_backup_plans_plan_backup_file_get) | **GET** /plan/backup/file/ | List File Backup Plans
[**list_image_backup_history_plan_backup_image_plan_id_history_get**](PlansBackupApi.md#list_image_backup_history_plan_backup_image_plan_id_history_get) | **GET** /plan/backup/image/{plan_id}/history/ | List Image Backup History
[**list_image_backup_plans_plan_backup_image_get**](PlansBackupApi.md#list_image_backup_plans_plan_backup_image_get) | **GET** /plan/backup/image/ | List Image Backup Plans
[**remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**](PlansBackupApi.md#remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/remove-agent/{agent_id}/ | Remove Backup Plan Agent
[**remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**](PlansBackupApi.md#remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/remove-schedule/{schedule_id}/ | Remove Backup Plan Schedule
[**update_file_backup_plans_plan_backup_file_plan_id_put**](PlansBackupApi.md#update_file_backup_plans_plan_backup_file_plan_id_put) | **PUT** /plan/backup/file/{plan_id}/ | Update File Backup Plans
[**update_image_backup_plans_plan_backup_image_plan_id_put**](PlansBackupApi.md#update_image_backup_plans_plan_backup_image_plan_id_put) | **PUT** /plan/backup/image/{plan_id}/ | Update Image Backup Plans


# **assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**
> assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)

Assign Backup Plan Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Assign Backup Plan Agent
        api_instance.assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**
> assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)

Assign Backup Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Assign Backup Plan Schedule
        api_instance.assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **schedule_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_file_backup_plans_plan_backup_file_post**
> create_file_backup_plans_plan_backup_file_post(file_backup_plan_create, cbe_user_org_id=cbe_user_org_id)

Create File Backup Plans

# Create file backup plan

Create a new file backup plan in the backup manager. File plans wrap a complete backup configuration and must declare at least one absolute `config.source_paths` entry.

**Endpoint**: `POST /backup/file/`

**Auth**: requires an authenticated user.

## Request body (FileBackupPlanCreate)
- `name` (string, required): Human-friendly plan name.
- `repo_id` (uuid, required): Target repository id.
- `config` (ResticBackup, required): Must include `source_paths` (absolute paths); supports `exclude`, `iexclude`, `exclude_caches`, `exclude_if_present`, `exclude_larger_than`, and `global_options.limit_download` / `global_options.limit_upload`.
- `schedule_enabled` (bool, default `false`): Whether scheduling is active for this plan.
- `schedule_config_id` (uuid, optional): Scheduling configuration to attach at creation when `schedule_enabled` is true.
- `pre_script`, `post_script` (PrePostRunScript, optional): Hooks around the backup run. Fields: `executor`, `script_path`, `args`, `envs`, `abort_if_fail`, optional inline `script`.

Validation highlights: `config.source_paths` is mandatory and each path must be absolute. If provided, `pre_script`/`post_script` must include an executor and script path.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_backup_plan_create import FileBackupPlanCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    file_backup_plan_create = {"name":"Sample file plan","repo_id":"2783d0b1-d178-499b-ad7b-733670bde27b","config":{"source_paths":["C:\\Users"]},"schedule_enabled":true,"schedule_config_id":"b180658b-1799-4563-a5ce-2eb131e51e0e"} # FileBackupPlanCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create File Backup Plans
        api_instance.create_file_backup_plans_plan_backup_file_post(file_backup_plan_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->create_file_backup_plans_plan_backup_file_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_backup_plan_create** | [**FileBackupPlanCreate**](FileBackupPlanCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_image_backup_plans_plan_backup_image_post**
> create_image_backup_plans_plan_backup_image_post(image_backup_plan_create, cbe_user_org_id=cbe_user_org_id)

Create Image Backup Plans

# Create image backup plan

Create a new image backup plan in the backup manager. Image plans wrap backup configuration and must NOT declare `config.source_paths`; partitions are provided via the `extension` field.

**Endpoint**: `POST /backup/image/`
**Auth**: requires an authenticated user.

## Request body (ImageBackupPlanCreate)
- `name` (string, required): Human-friendly plan name.
- `repo_id` (uuid, required): Target repository id.
- `config` (ResticBackup, required): Restic options; must omit `source_paths`. Only `global_options.limit_download` / `global_options.limit_upload` have an impact.
- `schedule_enabled` (bool, default `false`): Whether scheduling is active for this plan.
- `schedule_config_id` (uuid, optional): Scheduling configuration to attach at creation when `schedule_enabled` is true.
- `extension` (ImageBackupPlanExtension, required): Disk-partitions map to backup. Example: `{ "partitions": { "0": [0,1] } }`.
- `pre_script`, `post_script` (PrePostRunScript, optional): Hooks around the backup run. Fields: `executor`, `script_path`, `args`, `envs`, `abort_if_fail`, optional inline `script`.

Validation highlights: `config.source_paths` is forbidden for image plans. `extension.partitions` must be provided. If `pre_script`/`post_script` are provided, they must include an executor and script path.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_backup_plan_create import ImageBackupPlanCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    image_backup_plan_create = {"name":"Sample file plan","repo_id":"2783d0b1-d178-499b-ad7b-733670bde27b","config":{},"extension":{"partitions":{"0":[0,1,2]}},"schedule_enabled":true,"schedule_config_id":"b180658b-1799-4563-a5ce-2eb131e51e0e"} # ImageBackupPlanCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Image Backup Plans
        api_instance.create_image_backup_plans_plan_backup_image_post(image_backup_plan_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->create_image_backup_plans_plan_backup_image_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **image_backup_plan_create** | [**ImageBackupPlanCreate**](ImageBackupPlanCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_file_backup_plans_plan_backup_file_plan_id_delete**
> delete_file_backup_plans_plan_backup_file_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)

Delete File Backup Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete File Backup Plans
        api_instance.delete_file_backup_plans_plan_backup_file_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->delete_file_backup_plans_plan_backup_file_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_image_backup_plans_plan_backup_image_plan_id_delete**
> delete_image_backup_plans_plan_backup_image_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)

Delete Image Backup Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Image Backup Plans
        api_instance.delete_image_backup_plans_plan_backup_image_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->delete_image_backup_plans_plan_backup_image_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_file_backup_plan_plan_backup_file_plan_id_execute_post**
> object execute_file_backup_plan_plan_backup_file_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)

Execute File Backup Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.additional_agent_filter import AdditionalAgentFilter
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)
    additional_agent_filter = {filter_agents=[8d9e8f7a-1b2c-4a3e-9f0b-123456789abc, 3f5a9c2e-7d1b-4f6c-8e90-abcdef123456]} # AdditionalAgentFilter |  (optional)

    try:
        # Execute File Backup Plan
        api_response = api_instance.execute_file_backup_plan_plan_backup_file_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)
        print("The response of PlansBackupApi->execute_file_backup_plan_plan_backup_file_plan_id_execute_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->execute_file_backup_plan_plan_backup_file_plan_id_execute_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 
 **additional_agent_filter** | [**AdditionalAgentFilter**](AdditionalAgentFilter.md)|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_image_backup_plan_plan_backup_image_plan_id_execute_post**
> object execute_image_backup_plan_plan_backup_image_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)

Execute Image Backup Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.additional_agent_filter import AdditionalAgentFilter
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)
    additional_agent_filter = {"filter_agents":["8d9e8f7a-1b2c-4a3e-9f0b-123456789abc","3f5a9c2e-7d1b-4f6c-8e90-abcdef123456"]} # AdditionalAgentFilter |  (optional)

    try:
        # Execute Image Backup Plan
        api_response = api_instance.execute_image_backup_plan_plan_backup_image_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)
        print("The response of PlansBackupApi->execute_image_backup_plan_plan_backup_image_plan_id_execute_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->execute_image_backup_plan_plan_backup_image_plan_id_execute_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 
 **additional_agent_filter** | [**AdditionalAgentFilter**](AdditionalAgentFilter.md)|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_file_backup_plan_plan_backup_file_plan_id_get**
> FileBackupPlan get_file_backup_plan_plan_backup_file_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)

Get File Backup Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_backup_plan import FileBackupPlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get File Backup Plan
        api_response = api_instance.get_file_backup_plan_plan_backup_file_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->get_file_backup_plan_plan_backup_file_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->get_file_backup_plan_plan_backup_file_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**FileBackupPlan**](FileBackupPlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_image_backup_plan_plan_backup_image_plan_id_get**
> ImageBackupPlan get_image_backup_plan_plan_backup_image_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)

Get Image Backup Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_backup_plan import ImageBackupPlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Image Backup Plan
        api_response = api_instance.get_image_backup_plan_plan_backup_image_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->get_image_backup_plan_plan_backup_image_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->get_image_backup_plan_plan_backup_image_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**ImageBackupPlan**](ImageBackupPlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get**
> BackupInfo get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get(plan_run_id, cbe_user_org_id=cbe_user_org_id)

Get Running Plan Status

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.backup_info import BackupInfo
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_run_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Running Plan Status
        api_response = api_instance.get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get(plan_run_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_run_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**BackupInfo**](BackupInfo.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_backup_history_plan_backup_history_get**
> PageBackupPlanRun list_all_backup_history_plan_backup_history_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)

List All Backup History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_backup_plan_run import PageBackupPlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    status = cybee_sdk.api.PlanStatus() # PlanStatus |  (optional)
    finished_at_gt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_lt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List All Backup History
        api_response = api_instance.list_all_backup_history_plan_backup_history_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_all_backup_history_plan_backup_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_all_backup_history_plan_backup_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **plan_id** | **UUID**|  | [optional] 
 **repository_id** | **UUID**|  | [optional] 
 **agent_id** | **UUID**|  | [optional] 
 **status** | [**PlanStatus**](.md)|  | [optional] 
 **finished_at_gt** | **datetime**|  | [optional] 
 **finished_at_lt** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_latest_backup_history_plan_backup_history_latest_get**
> PageBackupPlanRun list_all_latest_backup_history_plan_backup_history_latest_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)

List All Latest Backup History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_backup_plan_run import PageBackupPlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    status = cybee_sdk.api.PlanStatus() # PlanStatus |  (optional)
    finished_at_gt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_lt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List All Latest Backup History
        api_response = api_instance.list_all_latest_backup_history_plan_backup_history_latest_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_all_latest_backup_history_plan_backup_history_latest_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_all_latest_backup_history_plan_backup_history_latest_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **plan_id** | **UUID**|  | [optional] 
 **repository_id** | **UUID**|  | [optional] 
 **agent_id** | **UUID**|  | [optional] 
 **status** | [**PlanStatus**](.md)|  | [optional] 
 **finished_at_gt** | **datetime**|  | [optional] 
 **finished_at_lt** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_backup_history_plan_backup_file_plan_id_history_get**
> PageBackupPlanRun list_file_backup_history_plan_backup_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)

List File Backup History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_backup_plan_run import PageBackupPlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List File Backup History
        api_response = api_instance.list_file_backup_history_plan_backup_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_file_backup_history_plan_backup_file_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_file_backup_history_plan_backup_file_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_backup_plans_plan_backup_file_get**
> PageFileBackupPlan list_file_backup_plans_plan_backup_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)

List File Backup Plans

# List file backup plans

Fetch a paginated list of file backup plans configured in the backup manager. File plans wrap restic backup configuration and must declare at least one `config.source_paths` entry.

**Endpoint**: `GET /backup/file/`

**Auth**: requires an authenticated user.

## Query parameters
- `page` (int, default 0): Zero-based page index.
- `per_page` (int, default 25, max 50): Page size.
- `order_by` (list[str]): Optional sort fields forwarded to the backend.
- `id` (uuid): Filter by plan id.
- `name` (string): Filter by plan name.
- `repo_id` (uuid): Filter by repository id.
- `schedule_enabled` (bool): Filter by whether scheduling is enabled.
- `linked_agents__agent_id__in` (array[uuid]): Return plans assigned to any of the provided agent ids.

## Response
`200 OK` with a `Page[FileBackupPlan]` body:
- `page`, `per_page`, `total_items`, `total_pages`: Pagination metadata.
- `items`: Array of file backup plans with fields:
  - `id`, `name`, `repo_id`
  - `config`: Restic backup options (must include `source_paths`; may also include `exclude`, `exclude_caches`, `exclude_if_present`, `exclude_larger_than`, `iexclude`, `global_options.limit_download`, `global_options.limit_upload`).
  - `retention_settings`: Retention limits (`keep_*` and `keep_within_*_as_secs` fields).
  - `schedule_enabled`, `schedule_configs`
  - `last_executed`: Timestamp of the most recent run.
  - `timestamps`: `created_at`, `updated_at`
  - `affected_agents`: Agents linked to the plan.
  - `pre_script`, `post_script`: Optional scripts (executor, script_path, args, envs, abort_if_fail, script).

### Example

```http
GET /backup/file/?page=0&per_page=25&repo_id=2783d0b1-d178-499b-ad7b-733670bde27b HTTP/1.1
Authorization: Bearer <access_token>
```

```json
{
  "page": 0,
  "per_page": 25,
  "total_items": 1,
  "total_pages": 1,
  "items": [
    {
      "id": "c85a857f-4d70-4099-b84f-a6b74ea999de",
      "name": "Workstations home folders",
      "repo_id": "2783d0b1-d178-499b-ad7b-733670bde27b",
      "config": {
        "global_options": {
          "limit_download": null,
          "limit_upload": null
        },
        "source_paths": ["C:\\Users"],
        "exclude": ["*.tmp"],
        "exclude_caches": true,
        "exclude_if_present": [],
        "exclude_larger_than": null,
        "iexclude": []
      },
      "retention_settings": {
        "keep_last": 7,
        "keep_hourly": null,
        "keep_daily": null,
        "keep_weekly": null,
        "keep_monthly": null,
        "keep_yearly": null,
        "keep_within_as_secs": null,
        "keep_within_hourly_as_secs": null,
        "keep_within_daily_as_secs": null,
        "keep_within_weekly_as_secs": null,
        "keep_within_monthly_as_secs": null,
        "keep_within_yearly_as_secs": null
      },
      "schedule_enabled": true,
      "schedule_configs": ["b180658b-1799-4563-a5ce-2eb131e51e0e"],
      "last_executed": "2024-05-06T12:00:00Z",
      "timestamps": {
        "created_at": "2024-05-01T09:12:33Z",
        "updated_at": "2024-05-05T07:15:10Z"
      },
      "affected_agents": ["e33602da-cb5f-4b5f-9c49-6307b32cfac7"],
      "pre_script": null,
      "post_script": null
    }
  ]
}
```

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_file_backup_plan import PageFileBackupPlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    schedule_enabled = True # bool |  (optional)
    linked_agents_contains = None # List[UUID] |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List File Backup Plans
        api_response = api_instance.list_file_backup_plans_plan_backup_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_file_backup_plans_plan_backup_file_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_file_backup_plans_plan_backup_file_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **name** | [**str**](.md)|  | [optional] 
 **repo_id** | **UUID**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 
 **linked_agents_contains** | [**List[UUID]**](UUID.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageFileBackupPlan**](PageFileBackupPlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_backup_history_plan_backup_image_plan_id_history_get**
> PageBackupPlanRun list_image_backup_history_plan_backup_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)

List Image Backup History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_backup_plan_run import PageBackupPlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Image Backup History
        api_response = api_instance.list_image_backup_history_plan_backup_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_image_backup_history_plan_backup_image_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_image_backup_history_plan_backup_image_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_backup_plans_plan_backup_image_get**
> PageImageBackupPlan list_image_backup_plans_plan_backup_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)

List Image Backup Plans

# List image backup plans

Fetch a paginated list of image backup plans configured in the backup manager.

**Endpoint**: `GET /backup/image/`
**Auth**: requires an authenticated user.

## Query parameters
- `page` (int, default 0): Zero-based page index.
- `per_page` (int, default 25, max 50): Page size.
- `order_by` (list[str]): Optional sort fields forwarded to the backend.
- `id` (uuid): Filter by plan id.
- `name` (string): Filter by plan name.
- `repo_id` (uuid): Filter by repository id.
- `schedule_enabled` (bool): Filter by whether scheduling is enabled.
- `linked_agents__agent_id__in` (array[uuid]): Return plans assigned to any of the provided agent ids.

## Response
`200 OK` with a `Page[ImageBackupPlan]` body:
- `page`, `per_page`, `total_items`, `total_pages`: Pagination metadata.
- `items`: Array of image backup plans with fields:
  - `id`, `name`, `repo_id`
  - `config`: Restic backup options (must omit `source_paths`; only `global_options.limit_download` have an impact, `global_options.limit_upload`).
  - `extension.partitions`: Map of device index to partition index lists.
  - `retention_settings`: Retention limits (`keep_*` and `keep_within_*_as_secs` fields).
  - `schedule_enabled`, `schedule_configs`
  - `last_executed`: Timestamp of the most recent run.
  - `timestamps`: `created_at`, `updated_at`
  - `affected_agents`: Agents linked to the plan.
  - `pre_script`, `post_script`: Optional scripts (executor, script_path, args, envs, abort_if_fail, script).

### Example

```http
GET /backup/image/?page=0&per_page=25&repo_id=2783d0b1-d178-499b-ad7b-733670bde27b HTTP/1.1
Authorization: Bearer <access_token>
```

```json
{
  "page": 0,
  "per_page": 25,
  "total_items": 1,
  "total_pages": 1,
  "items": [
    {
      "id": "7b3a9d8a-ea9b-4dc1-9d1e-3cb3104f0d3c",
      "name": "Primary workstation image",
      "repo_id": "2783d0b1-d178-499b-ad7b-733670bde27b",
      "config": {
        "global_options": {
          "limit_download": null,
          "limit_upload": null
        },
        "exclude": [],
        "exclude_caches": false,
        "exclude_if_present": [],
        "exclude_larger_than": null,
        "iexclude": []
      },
      "extension": {
        "partitions": {
          "0": [0, 1]
        }
      },
      "retention_settings": {
        "keep_last": 3,
        "keep_hourly": null,
        "keep_daily": null,
        "keep_weekly": null,
        "keep_monthly": null,
        "keep_yearly": null,
        "keep_within_as_secs": null,
        "keep_within_hourly_as_secs": null,
        "keep_within_daily_as_secs": null,
        "keep_within_weekly_as_secs": null,
        "keep_within_monthly_as_secs": null,
        "keep_within_yearly_as_secs": null
      },
      "schedule_enabled": true,
      "schedule_configs": ["b180658b-1799-4563-a5ce-2eb131e51e0e"],
      "last_executed": "2024-05-06T12:00:00Z",
      "timestamps": {
        "created_at": "2024-05-01T09:12:33Z",
        "updated_at": "2024-05-05T07:15:10Z"
      },
      "affected_agents": ["e33602da-cb5f-4b5f-9c49-6307b32cfac7"],
      "pre_script": null,
      "post_script": null
    }
  ]
}
```

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_image_backup_plan import PageImageBackupPlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    schedule_enabled = True # bool |  (optional)
    linked_agents_contains = None # List[UUID] |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Image Backup Plans
        api_response = api_instance.list_image_backup_plans_plan_backup_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansBackupApi->list_image_backup_plans_plan_backup_image_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_image_backup_plans_plan_backup_image_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **name** | **str**|  | [optional] 
 **repo_id** | **UUID**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 
 **linked_agents_contains** | [**List[UUID]**](UUID.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageImageBackupPlan**](PageImageBackupPlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**
> remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)

Remove Backup Plan Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Remove Backup Plan Agent
        api_instance.remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**
> remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)

Remove Backup Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Remove Backup Plan Schedule
        api_instance.remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **schedule_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_file_backup_plans_plan_backup_file_plan_id_put**
> update_file_backup_plans_plan_backup_file_plan_id_put(plan_id, file_backup_plan_update, cbe_user_org_id=cbe_user_org_id)

Update File Backup Plans

# Update file backup plan

Update an existing file backup plan. Fields are optional; only provided values are updated. File plans wrap a backup configuration and must contain at least one absolute `config.source_paths`.

**Endpoint**: `PUT /backup/file/{plan_id}/`

**Auth**: requires an authenticated user.

## Path parameter
- `plan_id` (uuid, required): File backup plan identifier.

## Request body (FileBackupPlanUpdate)
- `name` (string, optional): New plan name.
- `repo_id` (uuid, optional): Repository id to target.
- `config` (ResticBackup, optional): Updated restic options; must include `source_paths` (absolute paths) if provided. Supports `exclude`, `iexclude`, `exclude_caches`, `exclude_if_present`, `exclude_larger_than`, and `global_options.limit_download` / `global_options.limit_upload`.
- `schedule_enabled` (bool, optional): Toggle scheduling for the plan.
- `pre_script`, `post_script` (PrePostRunScript, optional): Pre/post hooks. Fields: `executor`, `script_path`, `args`, `envs`, `abort_if_fail`, optional inline `script`.

Validation highlights: when `config` is present, `config.source_paths` is mandatory and each path must be absolute. If `pre_script`/`post_script` are provided, they must include an executor and script path.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_backup_plan_update import FileBackupPlanUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    file_backup_plan_update = {name=Workstations home folders (nightly), schedule_enabled=true} # FileBackupPlanUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update File Backup Plans
        api_instance.update_file_backup_plans_plan_backup_file_plan_id_put(plan_id, file_backup_plan_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->update_file_backup_plans_plan_backup_file_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **file_backup_plan_update** | [**FileBackupPlanUpdate**](FileBackupPlanUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_image_backup_plans_plan_backup_image_plan_id_put**
> update_image_backup_plans_plan_backup_image_plan_id_put(plan_id, image_backup_plan_update, cbe_user_org_id=cbe_user_org_id)

Update Image Backup Plans

# Update image backup plan

Update an existing image backup plan. Fields are optional; only provided values are updated. Image plans wrap restic backup configuration and must NOT include `config.source_paths` when `config` is supplied.

**Endpoint**: `PUT /backup/image/{plan_id}/`
**Auth**: requires an authenticated Zitadel user; the gateway forwards `Cbe-User-*` headers to the backup manager.

## Path parameter
- `plan_id` (uuid, required): Image backup plan identifier.

## Request body (ImageBackupPlanUpdate)
- `name` (string, optional): New plan name.
- `repo_id` (uuid, optional): Target repository id.
- `config` (ResticBackup, optional): Updated restic options; must omit `source_paths`. Only `global_options.limit_download` / `global_options.limit_upload` have an impact.
- `schedule_enabled` (bool, optional): Toggle scheduling for the plan.
- `extension` (ImageBackupPlanExtension, optional): Updated partitions map to backup, e.g. `{ "partitions": { "Disk0": [0,1] } }`.
- `pre_script`, `post_script` (PrePostRunScript, optional): Pre/post hooks. Fields: `executor`, `script_path`, `args`, `envs`, `abort_if_fail`, optional inline `script`.

Validation highlights: when `config` is present, `config.source_paths` must be absent. If `pre_script`/`post_script` are provided, they must include an executor and script path.

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_backup_plan_update import ImageBackupPlanUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansBackupApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    image_backup_plan_update = {"name":"Workstations home folders (nightly)","schedule_enabled":true} # ImageBackupPlanUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Image Backup Plans
        api_instance.update_image_backup_plans_plan_backup_image_plan_id_put(plan_id, image_backup_plan_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->update_image_backup_plans_plan_backup_image_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **image_backup_plan_update** | [**ImageBackupPlanUpdate**](ImageBackupPlanUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

