# cybee_sdk.api.PlansRestoreApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**](PlansRestoreApi.md#assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/assign-agent/{agent_id}/ | Assign Restore Plan Agent
[**assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**](PlansRestoreApi.md#assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/assign-schedule/{schedule_id}/ | Assign Restore Plan Schedule
[**create_file_restore_plans_plan_restore_file_post**](PlansRestoreApi.md#create_file_restore_plans_plan_restore_file_post) | **POST** /plan/restore/file/ | Create File Restore Plans
[**create_image_restore_plans_plan_restore_image_post**](PlansRestoreApi.md#create_image_restore_plans_plan_restore_image_post) | **POST** /plan/restore/image/ | Create Image Restore Plans
[**delete_file_restore_plans_plan_restore_file_plan_id_delete**](PlansRestoreApi.md#delete_file_restore_plans_plan_restore_file_plan_id_delete) | **DELETE** /plan/restore/file/{plan_id}/ | Delete File Restore Plans
[**delete_image_restore_plans_plan_restore_image_plan_id_delete**](PlansRestoreApi.md#delete_image_restore_plans_plan_restore_image_plan_id_delete) | **DELETE** /plan/restore/image/{plan_id}/ | Delete Image Restore Plans
[**execute_file_restore_plan_plan_restore_file_plan_id_execute_post**](PlansRestoreApi.md#execute_file_restore_plan_plan_restore_file_plan_id_execute_post) | **POST** /plan/restore/file/{plan_id}/execute/ | Execute File Restore Plan
[**execute_image_restore_plan_plan_restore_image_plan_id_execute_post**](PlansRestoreApi.md#execute_image_restore_plan_plan_restore_image_plan_id_execute_post) | **POST** /plan/restore/image/{plan_id}/execute/ | Execute Image Restore Plan
[**get_file_restore_plan_plan_restore_file_plan_id_get**](PlansRestoreApi.md#get_file_restore_plan_plan_restore_file_plan_id_get) | **GET** /plan/restore/file/{plan_id}/ | Get File Restore Plan
[**get_image_restore_plan_plan_restore_image_plan_id_get**](PlansRestoreApi.md#get_image_restore_plan_plan_restore_image_plan_id_get) | **GET** /plan/restore/image/{plan_id}/ | Get Image Restore Plan
[**get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get**](PlansRestoreApi.md#get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get) | **GET** /plan/restore/restore/run/{plan_run_id}/status/ | Get Running Plan Status
[**list_all_latest_restore_history_plan_restore_history_latest_get**](PlansRestoreApi.md#list_all_latest_restore_history_plan_restore_history_latest_get) | **GET** /plan/restore/history/latest/ | List All Latest Restore History
[**list_all_restore_history_plan_restore_history_get**](PlansRestoreApi.md#list_all_restore_history_plan_restore_history_get) | **GET** /plan/restore/history/ | List All Restore History
[**list_file_restore_history_plan_restore_file_plan_id_history_get**](PlansRestoreApi.md#list_file_restore_history_plan_restore_file_plan_id_history_get) | **GET** /plan/restore/file/{plan_id}/history/ | List File Restore History
[**list_file_restore_plans_plan_restore_file_get**](PlansRestoreApi.md#list_file_restore_plans_plan_restore_file_get) | **GET** /plan/restore/file/ | List File Restore Plans
[**list_image_restore_history_plan_restore_image_plan_id_history_get**](PlansRestoreApi.md#list_image_restore_history_plan_restore_image_plan_id_history_get) | **GET** /plan/restore/image/{plan_id}/history/ | List Image Restore History
[**list_image_restore_plans_plan_restore_image_get**](PlansRestoreApi.md#list_image_restore_plans_plan_restore_image_get) | **GET** /plan/restore/image/ | List Image Restore Plans
[**remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**](PlansRestoreApi.md#remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/remove-agent/{agent_id}/ | Remove Restore Plan Agent
[**remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**](PlansRestoreApi.md#remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/remove-schedule/{schedule_id}/ | Remove Restore Plan Schedule
[**update_file_restore_plans_plan_restore_file_plan_id_put**](PlansRestoreApi.md#update_file_restore_plans_plan_restore_file_plan_id_put) | **PUT** /plan/restore/file/{plan_id}/ | Update File Restore Plans
[**update_image_restore_plans_plan_restore_image_plan_id_put**](PlansRestoreApi.md#update_image_restore_plans_plan_restore_image_plan_id_put) | **PUT** /plan/restore/image/{plan_id}/ | Update Image Restore Plans


# **assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**
> assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)

Assign Restore Plan Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Assign Restore Plan Agent
        api_instance.assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**
> assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)

Assign Restore Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Assign Restore Plan Schedule
        api_instance.assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **schedule_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_file_restore_plans_plan_restore_file_post**
> create_file_restore_plans_plan_restore_file_post(file_restore_plan_create, cbe_user_org_id=cbe_user_org_id)

Create File Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_restore_plan_create import FileRestorePlanCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    file_restore_plan_create = cybee_sdk.api.FileRestorePlanCreate() # FileRestorePlanCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create File Restore Plans
        api_instance.create_file_restore_plans_plan_restore_file_post(file_restore_plan_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->create_file_restore_plans_plan_restore_file_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_restore_plan_create** | [**FileRestorePlanCreate**](FileRestorePlanCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_image_restore_plans_plan_restore_image_post**
> create_image_restore_plans_plan_restore_image_post(image_restore_plan_create, cbe_user_org_id=cbe_user_org_id)

Create Image Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_restore_plan_create import ImageRestorePlanCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    image_restore_plan_create = cybee_sdk.api.ImageRestorePlanCreate() # ImageRestorePlanCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Image Restore Plans
        api_instance.create_image_restore_plans_plan_restore_image_post(image_restore_plan_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->create_image_restore_plans_plan_restore_image_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **image_restore_plan_create** | [**ImageRestorePlanCreate**](ImageRestorePlanCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_file_restore_plans_plan_restore_file_plan_id_delete**
> delete_file_restore_plans_plan_restore_file_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)

Delete File Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete File Restore Plans
        api_instance.delete_file_restore_plans_plan_restore_file_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->delete_file_restore_plans_plan_restore_file_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_image_restore_plans_plan_restore_image_plan_id_delete**
> delete_image_restore_plans_plan_restore_image_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)

Delete Image Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Image Restore Plans
        api_instance.delete_image_restore_plans_plan_restore_image_plan_id_delete(plan_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->delete_image_restore_plans_plan_restore_image_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_file_restore_plan_plan_restore_file_plan_id_execute_post**
> object execute_file_restore_plan_plan_restore_file_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)

Execute File Restore Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.additional_agent_filter import AdditionalAgentFilter
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)
    additional_agent_filter = {filter_agents=[8d9e8f7a-1b2c-4a3e-9f0b-123456789abc, 3f5a9c2e-7d1b-4f6c-8e90-abcdef123456]} # AdditionalAgentFilter |  (optional)

    try:
        # Execute File Restore Plan
        api_response = api_instance.execute_file_restore_plan_plan_restore_file_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)
        print("The response of PlansRestoreApi->execute_file_restore_plan_plan_restore_file_plan_id_execute_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->execute_file_restore_plan_plan_restore_file_plan_id_execute_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 
 **additional_agent_filter** | [**AdditionalAgentFilter**](AdditionalAgentFilter.md)|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_image_restore_plan_plan_restore_image_plan_id_execute_post**
> object execute_image_restore_plan_plan_restore_image_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)

Execute Image Restore Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.additional_agent_filter import AdditionalAgentFilter
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)
    additional_agent_filter = {filter_agents=[8d9e8f7a-1b2c-4a3e-9f0b-123456789abc, 3f5a9c2e-7d1b-4f6c-8e90-abcdef123456]} # AdditionalAgentFilter |  (optional)

    try:
        # Execute Image Restore Plan
        api_response = api_instance.execute_image_restore_plan_plan_restore_image_plan_id_execute_post(plan_id, cbe_user_org_id=cbe_user_org_id, additional_agent_filter=additional_agent_filter)
        print("The response of PlansRestoreApi->execute_image_restore_plan_plan_restore_image_plan_id_execute_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->execute_image_restore_plan_plan_restore_image_plan_id_execute_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 
 **additional_agent_filter** | [**AdditionalAgentFilter**](AdditionalAgentFilter.md)|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_file_restore_plan_plan_restore_file_plan_id_get**
> FileRestorePlan get_file_restore_plan_plan_restore_file_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)

Get File Restore Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_restore_plan import FileRestorePlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get File Restore Plan
        api_response = api_instance.get_file_restore_plan_plan_restore_file_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->get_file_restore_plan_plan_restore_file_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->get_file_restore_plan_plan_restore_file_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**FileRestorePlan**](FileRestorePlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_image_restore_plan_plan_restore_image_plan_id_get**
> ImageRestorePlan get_image_restore_plan_plan_restore_image_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)

Get Image Restore Plan

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_restore_plan import ImageRestorePlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Image Restore Plan
        api_response = api_instance.get_image_restore_plan_plan_restore_image_plan_id_get(plan_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->get_image_restore_plan_plan_restore_image_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->get_image_restore_plan_plan_restore_image_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**ImageRestorePlan**](ImageRestorePlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get**
> RestorationInfo get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get(plan_run_id, cbe_user_org_id=cbe_user_org_id)

Get Running Plan Status

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.restoration_info import RestorationInfo
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_run_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Running Plan Status
        api_response = api_instance.get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get(plan_run_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_run_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**RestorationInfo**](RestorationInfo.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_latest_restore_history_plan_restore_history_latest_get**
> PageRestorePlanRun list_all_latest_restore_history_plan_restore_history_latest_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)

List All Latest Restore History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_restore_plan_run import PageRestorePlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    status = cybee_sdk.api.PlanStatus() # PlanStatus |  (optional)
    finished_at_gt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_lt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List All Latest Restore History
        api_response = api_instance.list_all_latest_restore_history_plan_restore_history_latest_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_all_latest_restore_history_plan_restore_history_latest_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_all_latest_restore_history_plan_restore_history_latest_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **plan_id** | **UUID**|  | [optional] 
 **repository_id** | **UUID**|  | [optional] 
 **agent_id** | **UUID**|  | [optional] 
 **status** | [**PlanStatus**](.md)|  | [optional] 
 **finished_at_gt** | **datetime**|  | [optional] 
 **finished_at_lt** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_restore_history_plan_restore_history_get**
> PageRestorePlanRun list_all_restore_history_plan_restore_history_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)

List All Restore History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_restore_plan_run import PageRestorePlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    status = cybee_sdk.api.PlanStatus() # PlanStatus |  (optional)
    finished_at_gt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_lt = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List All Restore History
        api_response = api_instance.list_all_restore_history_plan_restore_history_get(page=page, per_page=per_page, order_by=order_by, id=id, plan_id=plan_id, repository_id=repository_id, agent_id=agent_id, status=status, finished_at_gt=finished_at_gt, finished_at_lt=finished_at_lt, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_all_restore_history_plan_restore_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_all_restore_history_plan_restore_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **plan_id** | **UUID**|  | [optional] 
 **repository_id** | **UUID**|  | [optional] 
 **agent_id** | **UUID**|  | [optional] 
 **status** | [**PlanStatus**](.md)|  | [optional] 
 **finished_at_gt** | **datetime**|  | [optional] 
 **finished_at_lt** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_restore_history_plan_restore_file_plan_id_history_get**
> PageRestorePlanRun list_file_restore_history_plan_restore_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)

List File Restore History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_restore_plan_run import PageRestorePlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List File Restore History
        api_response = api_instance.list_file_restore_history_plan_restore_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_file_restore_history_plan_restore_file_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_file_restore_history_plan_restore_file_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_restore_plans_plan_restore_file_get**
> PageFileRestorePlan list_file_restore_plans_plan_restore_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)

List File Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_file_restore_plan import PageFileRestorePlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    schedule_enabled = True # bool |  (optional)
    linked_agents_contains = None # List[UUID] |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List File Restore Plans
        api_response = api_instance.list_file_restore_plans_plan_restore_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_file_restore_plans_plan_restore_file_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_file_restore_plans_plan_restore_file_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **name** | [**str**](.md)|  | [optional] 
 **repo_id** | **UUID**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 
 **linked_agents_contains** | [**List[UUID]**](UUID.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageFileRestorePlan**](PageFileRestorePlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_restore_history_plan_restore_image_plan_id_history_get**
> PageRestorePlanRun list_image_restore_history_plan_restore_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)

List Image Restore History

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_restore_plan_run import PageRestorePlanRun
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Image Restore History
        api_response = api_instance.list_image_restore_history_plan_restore_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_image_restore_history_plan_restore_image_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_image_restore_history_plan_restore_image_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_restore_plans_plan_restore_image_get**
> PageImageRestorePlan list_image_restore_plans_plan_restore_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)

List Image Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_image_restore_plan import PageImageRestorePlan
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    schedule_enabled = True # bool |  (optional)
    linked_agents_contains = None # List[UUID] |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Image Restore Plans
        api_response = api_instance.list_image_restore_plans_plan_restore_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled, linked_agents_contains=linked_agents_contains, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansRestoreApi->list_image_restore_plans_plan_restore_image_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_image_restore_plans_plan_restore_image_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **name** | [**str**](.md)|  | [optional] 
 **repo_id** | **UUID**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 
 **linked_agents_contains** | [**List[UUID]**](UUID.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageImageRestorePlan**](PageImageRestorePlan.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**
> remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)

Remove Restore Plan Agent

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Remove Restore Plan Agent
        api_instance.remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post(plan_id, agent_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **agent_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**
> remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)

Remove Restore Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Remove Restore Plan Schedule
        api_instance.remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **schedule_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_file_restore_plans_plan_restore_file_plan_id_put**
> update_file_restore_plans_plan_restore_file_plan_id_put(plan_id, file_restore_plan_update, cbe_user_org_id=cbe_user_org_id)

Update File Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.file_restore_plan_update import FileRestorePlanUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    file_restore_plan_update = cybee_sdk.api.FileRestorePlanUpdate() # FileRestorePlanUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update File Restore Plans
        api_instance.update_file_restore_plans_plan_restore_file_plan_id_put(plan_id, file_restore_plan_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->update_file_restore_plans_plan_restore_file_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **file_restore_plan_update** | [**FileRestorePlanUpdate**](FileRestorePlanUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_image_restore_plans_plan_restore_image_plan_id_put**
> update_image_restore_plans_plan_restore_image_plan_id_put(plan_id, image_restore_plan_update, cbe_user_org_id=cbe_user_org_id)

Update Image Restore Plans

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.image_restore_plan_update import ImageRestorePlanUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansRestoreApi(api_client)
    plan_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    image_restore_plan_update = cybee_sdk.api.ImageRestorePlanUpdate() # ImageRestorePlanUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Image Restore Plans
        api_instance.update_image_restore_plans_plan_restore_image_plan_id_put(plan_id, image_restore_plan_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->update_image_restore_plans_plan_restore_image_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **UUID**|  | 
 **image_restore_plan_update** | [**ImageRestorePlanUpdate**](ImageRestorePlanUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

