# cybee_sdk.api.PlansScheduleApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_plan_schedule_plan_schedule_schedule_post**](PlansScheduleApi.md#create_plan_schedule_plan_schedule_schedule_post) | **POST** /plan/schedule/schedule/ | Create Plan Schedule
[**delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**](PlansScheduleApi.md#delete_plan_schedule_plan_schedule_schedule_schedule_id_delete) | **DELETE** /plan/schedule/schedule/{schedule_id}/ | Delete Plan Schedule
[**list_plan_schedules_plan_schedule_schedule_get**](PlansScheduleApi.md#list_plan_schedules_plan_schedule_schedule_get) | **GET** /plan/schedule/schedule/ | List Plan Schedules
[**update_plan_schedule_plan_schedule_schedule_schedule_id_put**](PlansScheduleApi.md#update_plan_schedule_plan_schedule_schedule_schedule_id_put) | **PUT** /plan/schedule/schedule/{schedule_id}/ | Update Plan Schedule


# **create_plan_schedule_plan_schedule_schedule_post**
> Scheduling create_plan_schedule_plan_schedule_schedule_post(create_scheduling, cbe_user_org_id=cbe_user_org_id)

Create Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.create_scheduling import CreateScheduling
from cybee_sdk.api.models.scheduling import Scheduling
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansScheduleApi(api_client)
    create_scheduling = cybee_sdk.api.CreateScheduling() # CreateScheduling | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Plan Schedule
        api_response = api_instance.create_plan_schedule_plan_schedule_schedule_post(create_scheduling, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansScheduleApi->create_plan_schedule_plan_schedule_schedule_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->create_plan_schedule_plan_schedule_schedule_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_scheduling** | [**CreateScheduling**](CreateScheduling.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**Scheduling**](Scheduling.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**
> delete_plan_schedule_plan_schedule_schedule_schedule_id_delete(schedule_id, cbe_user_org_id=cbe_user_org_id)

Delete Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansScheduleApi(api_client)
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Plan Schedule
        api_instance.delete_plan_schedule_plan_schedule_schedule_schedule_id_delete(schedule_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->delete_plan_schedule_plan_schedule_schedule_schedule_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_plan_schedules_plan_schedule_schedule_get**
> PageScheduling list_plan_schedules_plan_schedule_schedule_get(page=page, per_page=per_page, order_by=order_by, id=id, enabled=enabled, cbe_user_org_id=cbe_user_org_id)

List Plan Schedules

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_scheduling import PageScheduling
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansScheduleApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = None # List[UUID] |  (optional)
    enabled = True # bool |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Plan Schedules
        api_response = api_instance.list_plan_schedules_plan_schedule_schedule_get(page=page, per_page=per_page, order_by=order_by, id=id, enabled=enabled, cbe_user_org_id=cbe_user_org_id)
        print("The response of PlansScheduleApi->list_plan_schedules_plan_schedule_schedule_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->list_plan_schedules_plan_schedule_schedule_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **enabled** | **bool**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageScheduling**](PageScheduling.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_plan_schedule_plan_schedule_schedule_schedule_id_put**
> update_plan_schedule_plan_schedule_schedule_schedule_id_put(schedule_id, update_scheduling, cbe_user_org_id=cbe_user_org_id)

Update Plan Schedule

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.update_scheduling import UpdateScheduling
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.PlansScheduleApi(api_client)
    schedule_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    update_scheduling = cybee_sdk.api.UpdateScheduling() # UpdateScheduling | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Plan Schedule
        api_instance.update_plan_schedule_plan_schedule_schedule_schedule_id_put(schedule_id, update_scheduling, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->update_plan_schedule_plan_schedule_schedule_schedule_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **UUID**|  | 
 **update_scheduling** | [**UpdateScheduling**](UpdateScheduling.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

