# cybee_sdk.api.StorageAccountApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_storage_account_storage_storage_account_post**](StorageAccountApi.md#create_storage_account_storage_storage_account_post) | **POST** /storage/storage-account/ | Create Storage Account
[**delete_storage_account_storage_storage_account_storage_account_id_delete**](StorageAccountApi.md#delete_storage_account_storage_storage_account_storage_account_id_delete) | **DELETE** /storage/storage-account/{storage_account_id}/ | Delete Storage Account
[**get_storage_account_storage_storage_account_storage_account_id_get**](StorageAccountApi.md#get_storage_account_storage_storage_account_storage_account_id_get) | **GET** /storage/storage-account/{storage_account_id}/ | Get Storage Account
[**list_storage_account_storage_storage_account_get**](StorageAccountApi.md#list_storage_account_storage_storage_account_get) | **GET** /storage/storage-account/ | List Storage Account
[**update_storage_account_storage_storage_account_storage_account_id_put**](StorageAccountApi.md#update_storage_account_storage_storage_account_storage_account_id_put) | **PUT** /storage/storage-account/{storage_account_id}/ | Update Storage Account


# **create_storage_account_storage_storage_account_post**
> create_storage_account_storage_storage_account_post(storage_account_create, cbe_user_org_id=cbe_user_org_id)

Create Storage Account

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_account_create import StorageAccountCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageAccountApi(api_client)
    storage_account_create = cybee_sdk.api.StorageAccountCreate() # StorageAccountCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Storage Account
        api_instance.create_storage_account_storage_storage_account_post(storage_account_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageAccountApi->create_storage_account_storage_storage_account_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_account_create** | [**StorageAccountCreate**](StorageAccountCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_storage_account_storage_storage_account_storage_account_id_delete**
> delete_storage_account_storage_storage_account_storage_account_id_delete(storage_account_id, cbe_user_org_id=cbe_user_org_id)

Delete Storage Account

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageAccountApi(api_client)
    storage_account_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Storage Account
        api_instance.delete_storage_account_storage_storage_account_storage_account_id_delete(storage_account_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageAccountApi->delete_storage_account_storage_storage_account_storage_account_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_account_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_storage_account_storage_storage_account_storage_account_id_get**
> StorageAccount get_storage_account_storage_storage_account_storage_account_id_get(storage_account_id, cbe_user_org_id=cbe_user_org_id)

Get Storage Account

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_account import StorageAccount
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageAccountApi(api_client)
    storage_account_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Storage Account
        api_response = api_instance.get_storage_account_storage_storage_account_storage_account_id_get(storage_account_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageAccountApi->get_storage_account_storage_storage_account_storage_account_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageAccountApi->get_storage_account_storage_storage_account_storage_account_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_account_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**StorageAccount**](StorageAccount.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_storage_account_storage_storage_account_get**
> PageStorageAccount list_storage_account_storage_storage_account_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, provider=provider, cbe_user_org_id=cbe_user_org_id)

List Storage Account

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_storage_account import PageStorageAccount
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageAccountApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    name = 'name_example' # str |  (optional)
    provider = cybee_sdk.api.S3Provider() # S3Provider |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Storage Account
        api_response = api_instance.list_storage_account_storage_storage_account_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, provider=provider, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageAccountApi->list_storage_account_storage_storage_account_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageAccountApi->list_storage_account_storage_storage_account_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **UUID**|  | [optional] 
 **name** | **str**|  | [optional] 
 **provider** | [**S3Provider**](.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageStorageAccount**](PageStorageAccount.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_storage_account_storage_storage_account_storage_account_id_put**
> update_storage_account_storage_storage_account_storage_account_id_put(storage_account_id, storage_account_update, cbe_user_org_id=cbe_user_org_id)

Update Storage Account

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_account_update import StorageAccountUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageAccountApi(api_client)
    storage_account_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    storage_account_update = cybee_sdk.api.StorageAccountUpdate() # StorageAccountUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Storage Account
        api_instance.update_storage_account_storage_storage_account_storage_account_id_put(storage_account_id, storage_account_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageAccountApi->update_storage_account_storage_storage_account_storage_account_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_account_id** | **UUID**|  | 
 **storage_account_update** | [**StorageAccountUpdate**](StorageAccountUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

