# cybee_sdk.api.StorageDestinationApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_storage_destination_storage_storage_destination_post**](StorageDestinationApi.md#create_storage_destination_storage_storage_destination_post) | **POST** /storage/storage-destination/ | Create Storage Destination
[**delete_storage_destination_storage_storage_destination_storage_destination_id_delete**](StorageDestinationApi.md#delete_storage_destination_storage_storage_destination_storage_destination_id_delete) | **DELETE** /storage/storage-destination/{storage_destination_id}/ | Delete Storage Destination
[**get_storage_destination_storage_storage_destination_storage_destination_id_get**](StorageDestinationApi.md#get_storage_destination_storage_storage_destination_storage_destination_id_get) | **GET** /storage/storage-destination/{storage_destination_id}/ | Get Storage Destination
[**list_storage_destination_storage_storage_destination_get**](StorageDestinationApi.md#list_storage_destination_storage_storage_destination_get) | **GET** /storage/storage-destination/ | List Storage Destination
[**update_storage_destination_storage_storage_destination_storage_destination_id_patch**](StorageDestinationApi.md#update_storage_destination_storage_storage_destination_storage_destination_id_patch) | **PATCH** /storage/storage-destination/{storage_destination_id}/ | Update Storage Destination


# **create_storage_destination_storage_storage_destination_post**
> StorageDestination create_storage_destination_storage_storage_destination_post(storage_destination_create, cbe_user_org_id=cbe_user_org_id)

Create Storage Destination

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_destination import StorageDestination
from cybee_sdk.api.models.storage_destination_create import StorageDestinationCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageDestinationApi(api_client)
    storage_destination_create = cybee_sdk.api.StorageDestinationCreate() # StorageDestinationCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Storage Destination
        api_response = api_instance.create_storage_destination_storage_storage_destination_post(storage_destination_create, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageDestinationApi->create_storage_destination_storage_storage_destination_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->create_storage_destination_storage_storage_destination_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_create** | [**StorageDestinationCreate**](StorageDestinationCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**StorageDestination**](StorageDestination.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_storage_destination_storage_storage_destination_storage_destination_id_delete**
> delete_storage_destination_storage_storage_destination_storage_destination_id_delete(storage_destination_id, cbe_user_org_id=cbe_user_org_id)

Delete Storage Destination

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageDestinationApi(api_client)
    storage_destination_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Storage Destination
        api_instance.delete_storage_destination_storage_storage_destination_storage_destination_id_delete(storage_destination_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->delete_storage_destination_storage_storage_destination_storage_destination_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_storage_destination_storage_storage_destination_storage_destination_id_get**
> StorageDestination get_storage_destination_storage_storage_destination_storage_destination_id_get(storage_destination_id, cbe_user_org_id=cbe_user_org_id)

Get Storage Destination

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_destination import StorageDestination
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageDestinationApi(api_client)
    storage_destination_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Storage Destination
        api_response = api_instance.get_storage_destination_storage_storage_destination_storage_destination_id_get(storage_destination_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageDestinationApi->get_storage_destination_storage_storage_destination_storage_destination_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->get_storage_destination_storage_storage_destination_storage_destination_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**StorageDestination**](StorageDestination.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_storage_destination_storage_storage_destination_get**
> PageStorageDestination list_storage_destination_storage_storage_destination_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, base_path=base_path, storage_account_id=storage_account_id, cbe_user_org_id=cbe_user_org_id)

List Storage Destination

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_storage_destination import PageStorageDestination
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageDestinationApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = None # List[Optional[UUID]] |  (optional)
    name = 'name_example' # str |  (optional)
    base_path = 'base_path_example' # str |  (optional)
    storage_account_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Storage Destination
        api_response = api_instance.list_storage_destination_storage_storage_destination_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, base_path=base_path, storage_account_id=storage_account_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageDestinationApi->list_storage_destination_storage_storage_destination_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->list_storage_destination_storage_storage_destination_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | [**List[Optional[UUID]]**](UUID.md)|  | [optional] 
 **name** | [**str**](.md)|  | [optional] 
 **base_path** | [**str**](.md)|  | [optional] 
 **storage_account_id** | **UUID**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageStorageDestination**](PageStorageDestination.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_storage_destination_storage_storage_destination_storage_destination_id_patch**
> update_storage_destination_storage_storage_destination_storage_destination_id_patch(storage_destination_id, storage_destination_update, cbe_user_org_id=cbe_user_org_id)

Update Storage Destination

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.storage_destination_update import StorageDestinationUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageDestinationApi(api_client)
    storage_destination_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    storage_destination_update = cybee_sdk.api.StorageDestinationUpdate() # StorageDestinationUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Storage Destination
        api_instance.update_storage_destination_storage_storage_destination_storage_destination_id_patch(storage_destination_id, storage_destination_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->update_storage_destination_storage_storage_destination_storage_destination_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_id** | **UUID**|  | 
 **storage_destination_update** | [**StorageDestinationUpdate**](StorageDestinationUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

