# cybee_sdk.api.StorageRepositoryApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_repository_storage_repository_post**](StorageRepositoryApi.md#create_repository_storage_repository_post) | **POST** /storage/repository/ | Create Repository
[**delete_repository_storage_repository_repository_id_delete**](StorageRepositoryApi.md#delete_repository_storage_repository_repository_id_delete) | **DELETE** /storage/repository/{repository_id}/ | Delete Repository
[**execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get**](StorageRepositoryApi.md#execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get) | **GET** /storage/repository/{repository_id}/maintenance/{maintenance_type}/execute/ | Execute Repository Maintenance
[**get_repository_maintenance_storage_repository_repository_id_maintenance_get**](StorageRepositoryApi.md#get_repository_maintenance_storage_repository_repository_id_maintenance_get) | **GET** /storage/repository/{repository_id}/maintenance/ | Get Repository Maintenance
[**get_repository_storage_repository_repository_id_get**](StorageRepositoryApi.md#get_repository_storage_repository_repository_id_get) | **GET** /storage/repository/{repository_id}/ | Get Repository
[**list_repository_checks_storage_repository_check_history_get**](StorageRepositoryApi.md#list_repository_checks_storage_repository_check_history_get) | **GET** /storage/repository/check-history/ | List Repository Checks
[**list_repository_prunes_storage_repository_prune_history_get**](StorageRepositoryApi.md#list_repository_prunes_storage_repository_prune_history_get) | **GET** /storage/repository/prune-history/ | List Repository Prunes
[**list_repository_stats_storage_repository_stats_get**](StorageRepositoryApi.md#list_repository_stats_storage_repository_stats_get) | **GET** /storage/repository/stats/ | List Repository Stats
[**list_repository_storage_repository_get**](StorageRepositoryApi.md#list_repository_storage_repository_get) | **GET** /storage/repository/ | List Repository
[**set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post**](StorageRepositoryApi.md#set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post) | **POST** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Set Repository Maintenance
[**unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete**](StorageRepositoryApi.md#unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete) | **DELETE** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Unset Repository Maintenance
[**update_repository_storage_repository_repository_id_patch**](StorageRepositoryApi.md#update_repository_storage_repository_repository_id_patch) | **PATCH** /storage/repository/{repository_id}/ | Update Repository


# **create_repository_storage_repository_post**
> create_repository_storage_repository_post(repository_create, cbe_user_org_id=cbe_user_org_id)

Create Repository

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.repository_create import RepositoryCreate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    repository_create = cybee_sdk.api.RepositoryCreate() # RepositoryCreate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Create Repository
        api_instance.create_repository_storage_repository_post(repository_create, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->create_repository_storage_repository_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_create** | [**RepositoryCreate**](RepositoryCreate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_repository_storage_repository_repository_id_delete**
> delete_repository_storage_repository_repository_id_delete(repository_id, cbe_user_org_id=cbe_user_org_id)

Delete Repository

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Delete Repository
        api_instance.delete_repository_storage_repository_repository_id_delete(repository_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->delete_repository_storage_repository_repository_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get**
> object execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get(maintenance_type, repository_id, cbe_user_org_id=cbe_user_org_id)

Execute Repository Maintenance

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.maintenance_type import MaintenanceType
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    maintenance_type = cybee_sdk.api.MaintenanceType() # MaintenanceType | 
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Execute Repository Maintenance
        api_response = api_instance.execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get(maintenance_type, repository_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **maintenance_type** | [**MaintenanceType**](.md)|  | 
 **repository_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

**object**

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_repository_maintenance_storage_repository_repository_id_maintenance_get**
> RepositoryMaintenance get_repository_maintenance_storage_repository_repository_id_maintenance_get(repository_id, cbe_user_org_id=cbe_user_org_id)

Get Repository Maintenance

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.repository_maintenance import RepositoryMaintenance
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Repository Maintenance
        api_response = api_instance.get_repository_maintenance_storage_repository_repository_id_maintenance_get(repository_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->get_repository_maintenance_storage_repository_repository_id_maintenance_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->get_repository_maintenance_storage_repository_repository_id_maintenance_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**RepositoryMaintenance**](RepositoryMaintenance.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_repository_storage_repository_repository_id_get**
> Repository get_repository_storage_repository_repository_id_get(repository_id, cbe_user_org_id=cbe_user_org_id)

Get Repository

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.repository import Repository
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Get Repository
        api_response = api_instance.get_repository_storage_repository_repository_id_get(repository_id, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->get_repository_storage_repository_repository_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->get_repository_storage_repository_repository_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**Repository**](Repository.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_repository_checks_storage_repository_check_history_get**
> PageRepositoryChecks list_repository_checks_storage_repository_check_history_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, started_at_ge=started_at_ge, started_at_le=started_at_le, finished_at_ge=finished_at_ge, finished_at_le=finished_at_le, cbe_user_org_id=cbe_user_org_id)

List Repository Checks

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_repository_checks import PageRepositoryChecks
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    repository_id = None # List[UUID] |  (optional)
    started_at_ge = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    started_at_le = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_ge = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_le = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Repository Checks
        api_response = api_instance.list_repository_checks_storage_repository_check_history_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, started_at_ge=started_at_ge, started_at_le=started_at_le, finished_at_ge=finished_at_ge, finished_at_le=finished_at_le, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->list_repository_checks_storage_repository_check_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->list_repository_checks_storage_repository_check_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **repository_id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **started_at_ge** | **datetime**|  | [optional] 
 **started_at_le** | **datetime**|  | [optional] 
 **finished_at_ge** | **datetime**|  | [optional] 
 **finished_at_le** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRepositoryChecks**](PageRepositoryChecks.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_repository_prunes_storage_repository_prune_history_get**
> PageRepositoryPrunes list_repository_prunes_storage_repository_prune_history_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, started_at_ge=started_at_ge, started_at_le=started_at_le, finished_at_ge=finished_at_ge, finished_at_le=finished_at_le, cbe_user_org_id=cbe_user_org_id)

List Repository Prunes

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_repository_prunes import PageRepositoryPrunes
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    repository_id = None # List[UUID] |  (optional)
    started_at_ge = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    started_at_le = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_ge = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    finished_at_le = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Repository Prunes
        api_response = api_instance.list_repository_prunes_storage_repository_prune_history_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, started_at_ge=started_at_ge, started_at_le=started_at_le, finished_at_ge=finished_at_ge, finished_at_le=finished_at_le, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->list_repository_prunes_storage_repository_prune_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->list_repository_prunes_storage_repository_prune_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **repository_id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **started_at_ge** | **datetime**|  | [optional] 
 **started_at_le** | **datetime**|  | [optional] 
 **finished_at_ge** | **datetime**|  | [optional] 
 **finished_at_le** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRepositoryPrunes**](PageRepositoryPrunes.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_repository_stats_storage_repository_stats_get**
> PageRepositoryStats list_repository_stats_storage_repository_stats_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, mode=mode, timestamp_ge=timestamp_ge, timestamp_le=timestamp_le, cbe_user_org_id=cbe_user_org_id)

List Repository Stats

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_repository_stats import PageRepositoryStats
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    repository_id = None # List[UUID] |  (optional)
    mode = cybee_sdk.api.ResticStatsModeEnum() # ResticStatsModeEnum |  (optional)
    timestamp_ge = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    timestamp_le = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Repository Stats
        api_response = api_instance.list_repository_stats_storage_repository_stats_get(page=page, per_page=per_page, order_by=order_by, repository_id=repository_id, mode=mode, timestamp_ge=timestamp_ge, timestamp_le=timestamp_le, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->list_repository_stats_storage_repository_stats_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->list_repository_stats_storage_repository_stats_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **repository_id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **mode** | [**ResticStatsModeEnum**](.md)|  | [optional] 
 **timestamp_ge** | **datetime**|  | [optional] 
 **timestamp_le** | **datetime**|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRepositoryStats**](PageRepositoryStats.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_repository_storage_repository_get**
> PageRepository list_repository_storage_repository_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, slug=slug, status=status, storage_destination_id=storage_destination_id, version=version, cbe_user_org_id=cbe_user_org_id)

List Repository

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.page_repository import PageRepository
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = None # List[UUID] |  (optional)
    name = 'name_example' # str |  (optional)
    slug = 'slug_example' # str |  (optional)
    status = cybee_sdk.api.RepositoryStatusEnum() # RepositoryStatusEnum |  (optional)
    storage_destination_id = None # List[UUID] |  (optional)
    version = cybee_sdk.api.ResticVersionEnum() # ResticVersionEnum |  (optional)
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # List Repository
        api_response = api_instance.list_repository_storage_repository_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, slug=slug, status=status, storage_destination_id=storage_destination_id, version=version, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->list_repository_storage_repository_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->list_repository_storage_repository_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **name** | [**str**](.md)|  | [optional] 
 **slug** | [**str**](.md)|  | [optional] 
 **status** | [**RepositoryStatusEnum**](.md)|  | [optional] 
 **storage_destination_id** | [**List[UUID]**](UUID.md)|  | [optional] 
 **version** | [**ResticVersionEnum**](.md)|  | [optional] 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**PageRepository**](PageRepository.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post**
> RepositoryMaintenance set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post(maintenance_type, repository_id, repository_maintenance_create_update, cbe_user_org_id=cbe_user_org_id)

Set Repository Maintenance

Modifie ou créé un paramétrage de maintenance

- **maintenance_type**: Peut être "check" ou "prune", voir la ressource **MaintenanceType**
- **schedule**: Une planification au format crontab, par exemple "0 0 * * *" pour une tâche quotidienne à minuit

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.maintenance_type import MaintenanceType
from cybee_sdk.api.models.repository_maintenance import RepositoryMaintenance
from cybee_sdk.api.models.repository_maintenance_create_update import RepositoryMaintenanceCreateUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    maintenance_type = cybee_sdk.api.MaintenanceType() # MaintenanceType | 
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    repository_maintenance_create_update = cybee_sdk.api.RepositoryMaintenanceCreateUpdate() # RepositoryMaintenanceCreateUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Set Repository Maintenance
        api_response = api_instance.set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post(maintenance_type, repository_id, repository_maintenance_create_update, cbe_user_org_id=cbe_user_org_id)
        print("The response of StorageRepositoryApi->set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **maintenance_type** | [**MaintenanceType**](.md)|  | 
 **repository_id** | **UUID**|  | 
 **repository_maintenance_create_update** | [**RepositoryMaintenanceCreateUpdate**](RepositoryMaintenanceCreateUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

[**RepositoryMaintenance**](RepositoryMaintenance.md)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete**
> unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete(maintenance_type, repository_id, cbe_user_org_id=cbe_user_org_id)

Unset Repository Maintenance

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.maintenance_type import MaintenanceType
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    maintenance_type = cybee_sdk.api.MaintenanceType() # MaintenanceType | 
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Unset Repository Maintenance
        api_instance.unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete(maintenance_type, repository_id, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **maintenance_type** | [**MaintenanceType**](.md)|  | 
 **repository_id** | **UUID**|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_repository_storage_repository_repository_id_patch**
> update_repository_storage_repository_repository_id_patch(repository_id, repository_update, cbe_user_org_id=cbe_user_org_id)

Update Repository

### Example

* OAuth Authentication (ZitadelWebAuthorizationBearer):
* Bearer Authentication (BearerToken):

```python
import cybee_sdk.api
from cybee_sdk.api.models.repository_update import RepositoryUpdate
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.StorageRepositoryApi(api_client)
    repository_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    repository_update = cybee_sdk.api.RepositoryUpdate() # RepositoryUpdate | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Update Repository
        api_instance.update_repository_storage_repository_repository_id_patch(repository_id, repository_update, cbe_user_org_id=cbe_user_org_id)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->update_repository_storage_repository_repository_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **UUID**|  | 
 **repository_update** | [**RepositoryUpdate**](RepositoryUpdate.md)|  | 
 **cbe_user_org_id** | **str**|  | [optional] 

### Return type

void (empty response body)

### Authorization

[ZitadelWebAuthorizationBearer](../README.md#ZitadelWebAuthorizationBearer), [BearerToken](../README.md#BearerToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

