# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from cybee_sdk.api.models.time_stamps import TimeStamps
from typing import Optional, Set
from typing_extensions import Self


class AgentInfo(BaseModel):
    """
    AgentInfo
    """  # noqa: E501

    id: UUID
    version: Optional[StrictStr] = None
    machine_id: StrictStr
    host_name: StrictStr
    custom_name: Optional[StrictStr] = None
    online: Optional[StrictBool] = None
    approved_at: Optional[datetime] = None
    last_seen: datetime
    timestamps: TimeStamps
    __properties: ClassVar[List[str]] = [
        "id",
        "version",
        "machine_id",
        "host_name",
        "custom_name",
        "online",
        "approved_at",
        "last_seen",
        "timestamps",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of timestamps
        if self.timestamps:
            _dict["timestamps"] = self.timestamps.to_dict()
        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict["version"] = None

        # set to None if custom_name (nullable) is None
        # and model_fields_set contains the field
        if self.custom_name is None and "custom_name" in self.model_fields_set:
            _dict["custom_name"] = None

        # set to None if online (nullable) is None
        # and model_fields_set contains the field
        if self.online is None and "online" in self.model_fields_set:
            _dict["online"] = None

        # set to None if approved_at (nullable) is None
        # and model_fields_set contains the field
        if self.approved_at is None and "approved_at" in self.model_fields_set:
            _dict["approved_at"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "version": obj.get("version"),
                "machine_id": obj.get("machine_id"),
                "host_name": obj.get("host_name"),
                "custom_name": obj.get("custom_name"),
                "online": obj.get("online"),
                "approved_at": obj.get("approved_at"),
                "last_seen": obj.get("last_seen"),
                "timestamps": TimeStamps.from_dict(obj["timestamps"]) if obj.get("timestamps") is not None else None,
            }
        )
        return _obj
