# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.backup_error import BackupError
from cybee_sdk.api.models.backup_fatal_error import BackupFatalError
from cybee_sdk.api.models.backup_status import BackupStatus
from cybee_sdk.api.models.backup_summary import BackupSummary
from cybee_sdk.api.models.backup_verbose_status import BackupVerboseStatus
from typing import Optional, Set
from typing_extensions import Self


class BackupInfo(BaseModel):
    """
    BackupInfo
    """  # noqa: E501

    status: Optional[BackupStatus] = None
    restic_error: Optional[BackupError] = None
    restic_fatal_error: Optional[BackupFatalError] = None
    verbose_status: Optional[BackupVerboseStatus] = None
    summary: Optional[BackupSummary] = None
    unknown: Optional[StrictStr] = None
    other_error: Optional[StrictStr] = None
    backup_ended: Optional[Dict[str, Any]] = None
    backup_fully_finished: Optional[Dict[str, Any]] = None
    timestamp: StrictStr
    backup_paths: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = [
        "status",
        "restic_error",
        "restic_fatal_error",
        "verbose_status",
        "summary",
        "unknown",
        "other_error",
        "backup_ended",
        "backup_fully_finished",
        "timestamp",
        "backup_paths",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackupInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restic_error
        if self.restic_error:
            _dict["restic_error"] = self.restic_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restic_fatal_error
        if self.restic_fatal_error:
            _dict["restic_fatal_error"] = self.restic_fatal_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verbose_status
        if self.verbose_status:
            _dict["verbose_status"] = self.verbose_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict["summary"] = self.summary.to_dict()
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        # set to None if restic_error (nullable) is None
        # and model_fields_set contains the field
        if self.restic_error is None and "restic_error" in self.model_fields_set:
            _dict["restic_error"] = None

        # set to None if restic_fatal_error (nullable) is None
        # and model_fields_set contains the field
        if self.restic_fatal_error is None and "restic_fatal_error" in self.model_fields_set:
            _dict["restic_fatal_error"] = None

        # set to None if verbose_status (nullable) is None
        # and model_fields_set contains the field
        if self.verbose_status is None and "verbose_status" in self.model_fields_set:
            _dict["verbose_status"] = None

        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict["summary"] = None

        # set to None if unknown (nullable) is None
        # and model_fields_set contains the field
        if self.unknown is None and "unknown" in self.model_fields_set:
            _dict["unknown"] = None

        # set to None if other_error (nullable) is None
        # and model_fields_set contains the field
        if self.other_error is None and "other_error" in self.model_fields_set:
            _dict["other_error"] = None

        # set to None if backup_ended (nullable) is None
        # and model_fields_set contains the field
        if self.backup_ended is None and "backup_ended" in self.model_fields_set:
            _dict["backup_ended"] = None

        # set to None if backup_fully_finished (nullable) is None
        # and model_fields_set contains the field
        if self.backup_fully_finished is None and "backup_fully_finished" in self.model_fields_set:
            _dict["backup_fully_finished"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackupInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "status": BackupStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
                "restic_error": BackupError.from_dict(obj["restic_error"])
                if obj.get("restic_error") is not None
                else None,
                "restic_fatal_error": BackupFatalError.from_dict(obj["restic_fatal_error"])
                if obj.get("restic_fatal_error") is not None
                else None,
                "verbose_status": BackupVerboseStatus.from_dict(obj["verbose_status"])
                if obj.get("verbose_status") is not None
                else None,
                "summary": BackupSummary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
                "unknown": obj.get("unknown"),
                "other_error": obj.get("other_error"),
                "backup_ended": obj.get("backup_ended"),
                "backup_fully_finished": obj.get("backup_fully_finished"),
                "timestamp": obj.get("timestamp"),
                "backup_paths": obj.get("backup_paths"),
            }
        )
        return _obj
