# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from cybee_sdk.api.models.plan_status import PlanStatus
from cybee_sdk.api.models.snapshot import Snapshot
from typing import Optional, Set
from typing_extensions import Self


class BackupPlanRun(BaseModel):
    """
    BackupPlanRun
    """  # noqa: E501

    id: UUID
    task_id: Optional[UUID] = None
    snapshot_id: Optional[StrictStr] = None
    agent_id: UUID
    programmed_at: Optional[datetime] = None
    repository_id: UUID
    started_at: Optional[datetime] = None
    finished_at: Optional[datetime] = None
    plan_config: Optional[StrictStr] = None
    plan_id: UUID
    plan_type: StrictStr
    status: Optional[PlanStatus] = None
    snapshots: Optional[List[Snapshot]] = None
    errors: Optional[List[UUID]] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "task_id",
        "snapshot_id",
        "agent_id",
        "programmed_at",
        "repository_id",
        "started_at",
        "finished_at",
        "plan_config",
        "plan_id",
        "plan_type",
        "status",
        "snapshots",
        "errors",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackupPlanRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in snapshots (list)
        _items = []
        if self.snapshots:
            for _item_snapshots in self.snapshots:
                if _item_snapshots:
                    _items.append(_item_snapshots.to_dict())
            _dict["snapshots"] = _items
        # set to None if task_id (nullable) is None
        # and model_fields_set contains the field
        if self.task_id is None and "task_id" in self.model_fields_set:
            _dict["task_id"] = None

        # set to None if snapshot_id (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_id is None and "snapshot_id" in self.model_fields_set:
            _dict["snapshot_id"] = None

        # set to None if programmed_at (nullable) is None
        # and model_fields_set contains the field
        if self.programmed_at is None and "programmed_at" in self.model_fields_set:
            _dict["programmed_at"] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict["started_at"] = None

        # set to None if finished_at (nullable) is None
        # and model_fields_set contains the field
        if self.finished_at is None and "finished_at" in self.model_fields_set:
            _dict["finished_at"] = None

        # set to None if plan_config (nullable) is None
        # and model_fields_set contains the field
        if self.plan_config is None and "plan_config" in self.model_fields_set:
            _dict["plan_config"] = None

        # set to None if snapshots (nullable) is None
        # and model_fields_set contains the field
        if self.snapshots is None and "snapshots" in self.model_fields_set:
            _dict["snapshots"] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict["errors"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackupPlanRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "task_id": obj.get("task_id"),
                "snapshot_id": obj.get("snapshot_id"),
                "agent_id": obj.get("agent_id"),
                "programmed_at": obj.get("programmed_at"),
                "repository_id": obj.get("repository_id"),
                "started_at": obj.get("started_at"),
                "finished_at": obj.get("finished_at"),
                "plan_config": obj.get("plan_config"),
                "plan_id": obj.get("plan_id"),
                "plan_type": obj.get("plan_type"),
                "status": obj.get("status"),
                "snapshots": [Snapshot.from_dict(_item) for _item in obj["snapshots"]]
                if obj.get("snapshots") is not None
                else None,
                "errors": obj.get("errors"),
            }
        )
        return _obj
