# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.dns import Dns
from cybee_sdk.api.models.filesystem import Filesystem
from cybee_sdk.api.models.iface import Iface
from cybee_sdk.api.models.mass_storage import MassStorage
from cybee_sdk.api.models.memory import Memory
from cybee_sdk.api.models.ntp import Ntp
from cybee_sdk.api.models.os import Os
from cybee_sdk.api.models.phy_cpu import PhyCpu
from typing import Optional, Set
from typing_extensions import Self


class HistoricalMachine(BaseModel):
    """
    HistoricalMachine
    """  # noqa: E501

    machine_id: StrictStr
    cpus: Optional[List[PhyCpu]] = None
    os: Optional[Os] = None
    mass_storage: Optional[List[MassStorage]] = None
    filesystems: Optional[List[Filesystem]] = None
    ifaces: Optional[List[Iface]] = None
    dns: Optional[List[Dns]] = None
    ntp: Optional[Ntp] = None
    memory: Optional[Memory] = None
    id: StrictStr
    started_at: datetime
    updated_at: datetime
    __properties: ClassVar[List[str]] = [
        "machine_id",
        "cpus",
        "os",
        "mass_storage",
        "filesystems",
        "ifaces",
        "dns",
        "ntp",
        "memory",
        "id",
        "started_at",
        "updated_at",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HistoricalMachine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cpus (list)
        _items = []
        if self.cpus:
            for _item_cpus in self.cpus:
                if _item_cpus:
                    _items.append(_item_cpus.to_dict())
            _dict["cpus"] = _items
        # override the default output from pydantic by calling `to_dict()` of os
        if self.os:
            _dict["os"] = self.os.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mass_storage (list)
        _items = []
        if self.mass_storage:
            for _item_mass_storage in self.mass_storage:
                if _item_mass_storage:
                    _items.append(_item_mass_storage.to_dict())
            _dict["mass_storage"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in filesystems (list)
        _items = []
        if self.filesystems:
            for _item_filesystems in self.filesystems:
                if _item_filesystems:
                    _items.append(_item_filesystems.to_dict())
            _dict["filesystems"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ifaces (list)
        _items = []
        if self.ifaces:
            for _item_ifaces in self.ifaces:
                if _item_ifaces:
                    _items.append(_item_ifaces.to_dict())
            _dict["ifaces"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dns (list)
        _items = []
        if self.dns:
            for _item_dns in self.dns:
                if _item_dns:
                    _items.append(_item_dns.to_dict())
            _dict["dns"] = _items
        # override the default output from pydantic by calling `to_dict()` of ntp
        if self.ntp:
            _dict["ntp"] = self.ntp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict["memory"] = self.memory.to_dict()
        # set to None if cpus (nullable) is None
        # and model_fields_set contains the field
        if self.cpus is None and "cpus" in self.model_fields_set:
            _dict["cpus"] = None

        # set to None if os (nullable) is None
        # and model_fields_set contains the field
        if self.os is None and "os" in self.model_fields_set:
            _dict["os"] = None

        # set to None if mass_storage (nullable) is None
        # and model_fields_set contains the field
        if self.mass_storage is None and "mass_storage" in self.model_fields_set:
            _dict["mass_storage"] = None

        # set to None if filesystems (nullable) is None
        # and model_fields_set contains the field
        if self.filesystems is None and "filesystems" in self.model_fields_set:
            _dict["filesystems"] = None

        # set to None if ifaces (nullable) is None
        # and model_fields_set contains the field
        if self.ifaces is None and "ifaces" in self.model_fields_set:
            _dict["ifaces"] = None

        # set to None if dns (nullable) is None
        # and model_fields_set contains the field
        if self.dns is None and "dns" in self.model_fields_set:
            _dict["dns"] = None

        # set to None if ntp (nullable) is None
        # and model_fields_set contains the field
        if self.ntp is None and "ntp" in self.model_fields_set:
            _dict["ntp"] = None

        # set to None if memory (nullable) is None
        # and model_fields_set contains the field
        if self.memory is None and "memory" in self.model_fields_set:
            _dict["memory"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HistoricalMachine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "machine_id": obj.get("machine_id"),
                "cpus": [PhyCpu.from_dict(_item) for _item in obj["cpus"]] if obj.get("cpus") is not None else None,
                "os": Os.from_dict(obj["os"]) if obj.get("os") is not None else None,
                "mass_storage": [MassStorage.from_dict(_item) for _item in obj["mass_storage"]]
                if obj.get("mass_storage") is not None
                else None,
                "filesystems": [Filesystem.from_dict(_item) for _item in obj["filesystems"]]
                if obj.get("filesystems") is not None
                else None,
                "ifaces": [Iface.from_dict(_item) for _item in obj["ifaces"]]
                if obj.get("ifaces") is not None
                else None,
                "dns": [Dns.from_dict(_item) for _item in obj["dns"]] if obj.get("dns") is not None else None,
                "ntp": Ntp.from_dict(obj["ntp"]) if obj.get("ntp") is not None else None,
                "memory": Memory.from_dict(obj["memory"]) if obj.get("memory") is not None else None,
                "id": obj.get("id"),
                "started_at": obj.get("started_at"),
                "updated_at": obj.get("updated_at"),
            }
        )
        return _obj
