# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from cybee_sdk.api.models.image_backup_plan_extension import ImageBackupPlanExtension
from cybee_sdk.api.models.pre_post_run_script import PrePostRunScript
from cybee_sdk.api.models.restic_backup_output import ResticBackupOutput
from cybee_sdk.api.models.retention_settings import RetentionSettings
from cybee_sdk.api.models.time_stamps import TimeStamps
from typing import Optional, Set
from typing_extensions import Self


class ImageBackupPlan(BaseModel):
    """
    ImageBackupPlan
    """  # noqa: E501

    id: UUID
    name: StrictStr
    repo_id: UUID
    config: ResticBackupOutput
    retention_settings: Optional[RetentionSettings] = None
    schedule_enabled: Optional[StrictBool] = False
    schedule_configs: Optional[List[UUID]] = None
    last_executed: Optional[datetime] = None
    timestamps: TimeStamps
    affected_agents: Optional[List[UUID]] = None
    extension: ImageBackupPlanExtension
    pre_script: Optional[PrePostRunScript] = None
    post_script: Optional[PrePostRunScript] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "repo_id",
        "config",
        "retention_settings",
        "schedule_enabled",
        "schedule_configs",
        "last_executed",
        "timestamps",
        "affected_agents",
        "extension",
        "pre_script",
        "post_script",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageBackupPlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict["config"] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of retention_settings
        if self.retention_settings:
            _dict["retention_settings"] = self.retention_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of timestamps
        if self.timestamps:
            _dict["timestamps"] = self.timestamps.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extension
        if self.extension:
            _dict["extension"] = self.extension.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pre_script
        if self.pre_script:
            _dict["pre_script"] = self.pre_script.to_dict()
        # override the default output from pydantic by calling `to_dict()` of post_script
        if self.post_script:
            _dict["post_script"] = self.post_script.to_dict()
        # set to None if retention_settings (nullable) is None
        # and model_fields_set contains the field
        if self.retention_settings is None and "retention_settings" in self.model_fields_set:
            _dict["retention_settings"] = None

        # set to None if schedule_configs (nullable) is None
        # and model_fields_set contains the field
        if self.schedule_configs is None and "schedule_configs" in self.model_fields_set:
            _dict["schedule_configs"] = None

        # set to None if last_executed (nullable) is None
        # and model_fields_set contains the field
        if self.last_executed is None and "last_executed" in self.model_fields_set:
            _dict["last_executed"] = None

        # set to None if pre_script (nullable) is None
        # and model_fields_set contains the field
        if self.pre_script is None and "pre_script" in self.model_fields_set:
            _dict["pre_script"] = None

        # set to None if post_script (nullable) is None
        # and model_fields_set contains the field
        if self.post_script is None and "post_script" in self.model_fields_set:
            _dict["post_script"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageBackupPlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "repo_id": obj.get("repo_id"),
                "config": ResticBackupOutput.from_dict(obj["config"]) if obj.get("config") is not None else None,
                "retention_settings": RetentionSettings.from_dict(obj["retention_settings"])
                if obj.get("retention_settings") is not None
                else None,
                "schedule_enabled": obj.get("schedule_enabled") if obj.get("schedule_enabled") is not None else False,
                "schedule_configs": obj.get("schedule_configs"),
                "last_executed": obj.get("last_executed"),
                "timestamps": TimeStamps.from_dict(obj["timestamps"]) if obj.get("timestamps") is not None else None,
                "affected_agents": obj.get("affected_agents"),
                "extension": ImageBackupPlanExtension.from_dict(obj["extension"])
                if obj.get("extension") is not None
                else None,
                "pre_script": PrePostRunScript.from_dict(obj["pre_script"])
                if obj.get("pre_script") is not None
                else None,
                "post_script": PrePostRunScript.from_dict(obj["post_script"])
                if obj.get("post_script") is not None
                else None,
            }
        )
        return _obj
