# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.partition import Partition
from cybee_sdk.api.models.phy_drive import PhyDrive
from cybee_sdk.api.models.storage_format import StorageFormat
from typing import Optional, Set
from typing_extensions import Self


class MassStorage(BaseModel):
    """
    A raw space generaly backed by a physical drive. It could also be the representation of a pool of drives or RAID. That is the space on which you find the partition table.  In a image backup / restoration context, it is the lower emptity you may list and on which you can select what to backup / restore.  ## Fields definition:  - device_path: The (System depend) logical path to access this raw space. - support: The logical or physical represetentation of the abstraction given by this object.   It's generaly a physical drive or a RAID but may also be composed by virtual raw spaces. - largest_free_space: The largest contigous space available on this storage.   It can be seen as the biggest size usable for a new partition.
    """  # noqa: E501

    storage_format: StorageFormat
    id: StrictStr
    device_path: StrictStr
    name: StrictStr
    total_size: StrictInt
    largest_free_space: StrictInt
    support: Optional[PhyDrive] = None
    content: Optional[List[Partition]] = None
    __properties: ClassVar[List[str]] = [
        "storage_format",
        "id",
        "device_path",
        "name",
        "total_size",
        "largest_free_space",
        "support",
        "content",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MassStorage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of support
        if self.support:
            _dict["support"] = self.support.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item_content in self.content:
                if _item_content:
                    _items.append(_item_content.to_dict())
            _dict["content"] = _items
        # set to None if support (nullable) is None
        # and model_fields_set contains the field
        if self.support is None and "support" in self.model_fields_set:
            _dict["support"] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict["content"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MassStorage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "storage_format": obj.get("storage_format"),
                "id": obj.get("id"),
                "device_path": obj.get("device_path"),
                "name": obj.get("name"),
                "total_size": obj.get("total_size"),
                "largest_free_space": obj.get("largest_free_space"),
                "support": PhyDrive.from_dict(obj["support"]) if obj.get("support") is not None else None,
                "content": [Partition.from_dict(_item) for _item in obj["content"]]
                if obj.get("content") is not None
                else None,
            }
        )
        return _obj
