# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.filesystem import Filesystem
from typing import Optional, Set
from typing_extensions import Self


class Partition(BaseModel):
    """
    A slice of space on a mass storage. It is the raw space on which you may find a filesystem. However, not all partition contains a filesystem.  ## Fields definition:  - table_index: The idex of this partition in the partition table. - device_path: The (System depend) logical path to access this raw space. - system_required: Requiered by the operating system to boot successfully   (EFI partition, System reserved on windows, `/boot` on Linux, and root filesystem container).
    """  # noqa: E501

    id: StrictStr
    table_index: StrictInt
    device_path: StrictStr
    size: StrictInt
    offset: Optional[StrictInt] = None
    system_required: StrictBool
    content: Optional[Filesystem] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "table_index",
        "device_path",
        "size",
        "offset",
        "system_required",
        "content",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Partition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict["content"] = self.content.to_dict()
        # set to None if offset (nullable) is None
        # and model_fields_set contains the field
        if self.offset is None and "offset" in self.model_fields_set:
            _dict["offset"] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict["content"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Partition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "table_index": obj.get("table_index"),
                "device_path": obj.get("device_path"),
                "size": obj.get("size"),
                "offset": obj.get("offset"),
                "system_required": obj.get("system_required"),
                "content": Filesystem.from_dict(obj["content"]) if obj.get("content") is not None else None,
            }
        )
        return _obj
