# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from cybee_sdk.api.models.restic_stats_mode_enum import ResticStatsModeEnum
from typing import Optional, Set
from typing_extensions import Self


class RepositoryStats(BaseModel):
    """
    RepositoryStats
    """  # noqa: E501

    timestamp: datetime
    mode: ResticStatsModeEnum
    repository_id: UUID
    total_size: StrictInt
    snapshots_count: StrictInt
    total_file_count: Optional[StrictInt] = None
    total_blob_count: Optional[StrictInt] = None
    total_uncompressed_size: Optional[StrictInt] = None
    compression_ratio: Optional[Union[StrictFloat, StrictInt]] = None
    compression_progress: Optional[Union[StrictFloat, StrictInt]] = None
    compression_space_saving: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = [
        "timestamp",
        "mode",
        "repository_id",
        "total_size",
        "snapshots_count",
        "total_file_count",
        "total_blob_count",
        "total_uncompressed_size",
        "compression_ratio",
        "compression_progress",
        "compression_space_saving",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if total_file_count (nullable) is None
        # and model_fields_set contains the field
        if self.total_file_count is None and "total_file_count" in self.model_fields_set:
            _dict["total_file_count"] = None

        # set to None if total_blob_count (nullable) is None
        # and model_fields_set contains the field
        if self.total_blob_count is None and "total_blob_count" in self.model_fields_set:
            _dict["total_blob_count"] = None

        # set to None if total_uncompressed_size (nullable) is None
        # and model_fields_set contains the field
        if self.total_uncompressed_size is None and "total_uncompressed_size" in self.model_fields_set:
            _dict["total_uncompressed_size"] = None

        # set to None if compression_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.compression_ratio is None and "compression_ratio" in self.model_fields_set:
            _dict["compression_ratio"] = None

        # set to None if compression_progress (nullable) is None
        # and model_fields_set contains the field
        if self.compression_progress is None and "compression_progress" in self.model_fields_set:
            _dict["compression_progress"] = None

        # set to None if compression_space_saving (nullable) is None
        # and model_fields_set contains the field
        if self.compression_space_saving is None and "compression_space_saving" in self.model_fields_set:
            _dict["compression_space_saving"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "timestamp": obj.get("timestamp"),
                "mode": obj.get("mode"),
                "repository_id": obj.get("repository_id"),
                "total_size": obj.get("total_size"),
                "snapshots_count": obj.get("snapshots_count"),
                "total_file_count": obj.get("total_file_count"),
                "total_blob_count": obj.get("total_blob_count"),
                "total_uncompressed_size": obj.get("total_uncompressed_size"),
                "compression_ratio": obj.get("compression_ratio"),
                "compression_progress": obj.get("compression_progress"),
                "compression_space_saving": obj.get("compression_space_saving"),
            }
        )
        return _obj
