# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.exclude_larger_than1 import ExcludeLargerThan1
from cybee_sdk.api.models.global_restic_options import GlobalResticOptions
from typing import Optional, Set
from typing_extensions import Self


class ResticBackupOutput(BaseModel):
    """
    ResticBackupOutput
    """  # noqa: E501

    global_options: Optional[GlobalResticOptions] = None
    source_paths: Optional[List[StrictStr]] = None
    exclude: Optional[List[StrictStr]] = None
    exclude_caches: Optional[StrictBool] = False
    exclude_if_present: Optional[List[StrictStr]] = None
    exclude_larger_than: Optional[ExcludeLargerThan1] = None
    iexclude: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = [
        "global_options",
        "source_paths",
        "exclude",
        "exclude_caches",
        "exclude_if_present",
        "exclude_larger_than",
        "iexclude",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResticBackupOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of global_options
        if self.global_options:
            _dict["global_options"] = self.global_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exclude_larger_than
        if self.exclude_larger_than:
            _dict["exclude_larger_than"] = self.exclude_larger_than.to_dict()
        # set to None if global_options (nullable) is None
        # and model_fields_set contains the field
        if self.global_options is None and "global_options" in self.model_fields_set:
            _dict["global_options"] = None

        # set to None if source_paths (nullable) is None
        # and model_fields_set contains the field
        if self.source_paths is None and "source_paths" in self.model_fields_set:
            _dict["source_paths"] = None

        # set to None if exclude_larger_than (nullable) is None
        # and model_fields_set contains the field
        if self.exclude_larger_than is None and "exclude_larger_than" in self.model_fields_set:
            _dict["exclude_larger_than"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResticBackupOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "global_options": GlobalResticOptions.from_dict(obj["global_options"])
                if obj.get("global_options") is not None
                else None,
                "source_paths": obj.get("source_paths"),
                "exclude": obj.get("exclude"),
                "exclude_caches": obj.get("exclude_caches") if obj.get("exclude_caches") is not None else False,
                "exclude_if_present": obj.get("exclude_if_present"),
                "exclude_larger_than": ExcludeLargerThan1.from_dict(obj["exclude_larger_than"])
                if obj.get("exclude_larger_than") is not None
                else None,
                "iexclude": obj.get("iexclude"),
            }
        )
        return _obj
