# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.restoration_error import RestorationError
from cybee_sdk.api.models.restoration_status import RestorationStatus
from cybee_sdk.api.models.restoration_summary import RestorationSummary
from cybee_sdk.api.models.restore_verbose_status import RestoreVerboseStatus
from typing import Optional, Set
from typing_extensions import Self


class RestorationInfo(BaseModel):
    """
    RestorationInfo
    """  # noqa: E501

    status: Optional[RestorationStatus] = None
    verbose_status: Optional[RestoreVerboseStatus] = None
    restoration_error: Optional[RestorationError] = None
    summary: Optional[RestorationSummary] = None
    unknown: Optional[StrictStr] = None
    other_error: Optional[StrictStr] = None
    restoration_ended: Optional[Dict[str, Any]] = None
    restoration_fully_finished: Optional[Dict[str, Any]] = None
    timestamp: StrictStr
    __properties: ClassVar[List[str]] = [
        "status",
        "verbose_status",
        "restoration_error",
        "summary",
        "unknown",
        "other_error",
        "restoration_ended",
        "restoration_fully_finished",
        "timestamp",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RestorationInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verbose_status
        if self.verbose_status:
            _dict["verbose_status"] = self.verbose_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restoration_error
        if self.restoration_error:
            _dict["restoration_error"] = self.restoration_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict["summary"] = self.summary.to_dict()
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        # set to None if verbose_status (nullable) is None
        # and model_fields_set contains the field
        if self.verbose_status is None and "verbose_status" in self.model_fields_set:
            _dict["verbose_status"] = None

        # set to None if restoration_error (nullable) is None
        # and model_fields_set contains the field
        if self.restoration_error is None and "restoration_error" in self.model_fields_set:
            _dict["restoration_error"] = None

        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict["summary"] = None

        # set to None if unknown (nullable) is None
        # and model_fields_set contains the field
        if self.unknown is None and "unknown" in self.model_fields_set:
            _dict["unknown"] = None

        # set to None if other_error (nullable) is None
        # and model_fields_set contains the field
        if self.other_error is None and "other_error" in self.model_fields_set:
            _dict["other_error"] = None

        # set to None if restoration_ended (nullable) is None
        # and model_fields_set contains the field
        if self.restoration_ended is None and "restoration_ended" in self.model_fields_set:
            _dict["restoration_ended"] = None

        # set to None if restoration_fully_finished (nullable) is None
        # and model_fields_set contains the field
        if self.restoration_fully_finished is None and "restoration_fully_finished" in self.model_fields_set:
            _dict["restoration_fully_finished"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RestorationInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "status": RestorationStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
                "verbose_status": RestoreVerboseStatus.from_dict(obj["verbose_status"])
                if obj.get("verbose_status") is not None
                else None,
                "restoration_error": RestorationError.from_dict(obj["restoration_error"])
                if obj.get("restoration_error") is not None
                else None,
                "summary": RestorationSummary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
                "unknown": obj.get("unknown"),
                "other_error": obj.get("other_error"),
                "restoration_ended": obj.get("restoration_ended"),
                "restoration_fully_finished": obj.get("restoration_fully_finished"),
                "timestamp": obj.get("timestamp"),
            }
        )
        return _obj
