# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cybee_sdk.api.models.s3_signature_version_enum import S3SignatureVersionEnum
from typing import Optional, Set
from typing_extensions import Self


class S3StorageAccountConfig(BaseModel):
    """
    S3StorageAccountConfig
    """  # noqa: E501

    access_key: StrictStr
    secret_key: StrictStr
    signature_version: S3SignatureVersionEnum
    http_endpoint: Optional[StrictStr] = None
    https_endpoint: Optional[StrictStr] = None
    ignore_ssl: Optional[StrictBool] = False
    __properties: ClassVar[List[str]] = [
        "access_key",
        "secret_key",
        "signature_version",
        "http_endpoint",
        "https_endpoint",
        "ignore_ssl",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of S3StorageAccountConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if http_endpoint (nullable) is None
        # and model_fields_set contains the field
        if self.http_endpoint is None and "http_endpoint" in self.model_fields_set:
            _dict["http_endpoint"] = None

        # set to None if https_endpoint (nullable) is None
        # and model_fields_set contains the field
        if self.https_endpoint is None and "https_endpoint" in self.model_fields_set:
            _dict["https_endpoint"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of S3StorageAccountConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "access_key": obj.get("access_key"),
                "secret_key": obj.get("secret_key"),
                "signature_version": obj.get("signature_version"),
                "http_endpoint": obj.get("http_endpoint"),
                "https_endpoint": obj.get("https_endpoint"),
                "ignore_ssl": obj.get("ignore_ssl") if obj.get("ignore_ssl") is not None else False,
            }
        )
        return _obj
