# coding: utf-8

"""
Cybee API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.31.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from cybee_sdk.api.models.storage_destination_config import StorageDestinationConfig
from typing import Optional, Set
from typing_extensions import Self


class StorageDestinationCreate(BaseModel):
    """
    StorageDestinationCreate
    """  # noqa: E501

    name: Annotated[str, Field(min_length=1, strict=True)]
    description: Optional[StrictStr] = None
    base_path: Annotated[str, Field(min_length=1, strict=True)]
    storage_account_id: UUID
    configs: StorageDestinationConfig
    __properties: ClassVar[List[str]] = ["name", "description", "base_path", "storage_account_id", "configs"]

    @field_validator("base_path")
    def base_path_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_\/. \\]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_\/. \\]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageDestinationCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configs
        if self.configs:
            _dict["configs"] = self.configs.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageDestinationCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "base_path": obj.get("base_path"),
                "storage_account_id": obj.get("storage_account_id"),
                "configs": StorageDestinationConfig.from_dict(obj["configs"])
                if obj.get("configs") is not None
                else None,
            }
        )
        return _obj
