# cybee-sdk.api
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The `cybee_sdk.api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.31.1
- Package version: 0.31.1
- Generator version: 7.21.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 2.1.0, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with cybee-sdk.api,
you can run the following:

```python

import cybee_sdk.api
from cybee_sdk.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = cybee_sdk.api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerToken
configuration = cybee_sdk.api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with cybee_sdk.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cybee_sdk.api.AgentsApi(api_client)
    agent_id = UUID('38400000-8cf0-11bd-b23e-10b96e4ef00d') # UUID | 
    cbe_user_org_id = 'cbe_user_org_id_example' # str |  (optional)

    try:
        # Approve Agent
        api_instance.approve_agent_agent_agent_id_approve_post(agent_id, cbe_user_org_id=cbe_user_org_id)
    except ApiException as e:
        print("Exception when calling AgentsApi->approve_agent_agent_agent_id_approve_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentsApi* | [**approve_agent_agent_agent_id_approve_post**](cybee_sdk/api/docs/AgentsApi.md#approve_agent_agent_agent_id_approve_post) | **POST** /agent/{agent_id}/approve/ | Approve Agent
*AgentsApi* | [**delete_agent_agent_agent_id_delete**](cybee_sdk/api/docs/AgentsApi.md#delete_agent_agent_agent_id_delete) | **DELETE** /agent/{agent_id}/ | Delete Agent
*AgentsApi* | [**get_agent_agent_unregistered_get**](cybee_sdk/api/docs/AgentsApi.md#get_agent_agent_unregistered_get) | **GET** /agent/unregistered/ | Get Agent
*AgentsApi* | [**list_agent_agent_get**](cybee_sdk/api/docs/AgentsApi.md#list_agent_agent_get) | **GET** /agent/ | List Agent
*AgentsApi* | [**update_agent_agent_agent_id_put**](cybee_sdk/api/docs/AgentsApi.md#update_agent_agent_agent_id_put) | **PUT** /agent/{agent_id}/ | Update Agent
*CmdbApi* | [**list_cmdb_items_cmdb_machines_get**](cybee_sdk/api/docs/CmdbApi.md#list_cmdb_items_cmdb_machines_get) | **GET** /cmdb/machines/ | List Cmdb Items
*CmdbApi* | [**list_historical_cmdb_items_cmdb_machines_historical_get**](cybee_sdk/api/docs/CmdbApi.md#list_historical_cmdb_items_cmdb_machines_historical_get) | **GET** /cmdb/machines/historical/ | List Historical Cmdb Items
*PlansBackupApi* | [**assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**](cybee_sdk/api/docs/PlansBackupApi.md#assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/assign-agent/{agent_id}/ | Assign Backup Plan Agent
*PlansBackupApi* | [**assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**](cybee_sdk/api/docs/PlansBackupApi.md#assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/assign-schedule/{schedule_id}/ | Assign Backup Plan Schedule
*PlansBackupApi* | [**create_file_backup_plans_plan_backup_file_post**](cybee_sdk/api/docs/PlansBackupApi.md#create_file_backup_plans_plan_backup_file_post) | **POST** /plan/backup/file/ | Create File Backup Plans
*PlansBackupApi* | [**create_image_backup_plans_plan_backup_image_post**](cybee_sdk/api/docs/PlansBackupApi.md#create_image_backup_plans_plan_backup_image_post) | **POST** /plan/backup/image/ | Create Image Backup Plans
*PlansBackupApi* | [**delete_file_backup_plans_plan_backup_file_plan_id_delete**](cybee_sdk/api/docs/PlansBackupApi.md#delete_file_backup_plans_plan_backup_file_plan_id_delete) | **DELETE** /plan/backup/file/{plan_id}/ | Delete File Backup Plans
*PlansBackupApi* | [**delete_image_backup_plans_plan_backup_image_plan_id_delete**](cybee_sdk/api/docs/PlansBackupApi.md#delete_image_backup_plans_plan_backup_image_plan_id_delete) | **DELETE** /plan/backup/image/{plan_id}/ | Delete Image Backup Plans
*PlansBackupApi* | [**execute_file_backup_plan_plan_backup_file_plan_id_execute_post**](cybee_sdk/api/docs/PlansBackupApi.md#execute_file_backup_plan_plan_backup_file_plan_id_execute_post) | **POST** /plan/backup/file/{plan_id}/execute/ | Execute File Backup Plan
*PlansBackupApi* | [**execute_image_backup_plan_plan_backup_image_plan_id_execute_post**](cybee_sdk/api/docs/PlansBackupApi.md#execute_image_backup_plan_plan_backup_image_plan_id_execute_post) | **POST** /plan/backup/image/{plan_id}/execute/ | Execute Image Backup Plan
*PlansBackupApi* | [**get_file_backup_plan_plan_backup_file_plan_id_get**](cybee_sdk/api/docs/PlansBackupApi.md#get_file_backup_plan_plan_backup_file_plan_id_get) | **GET** /plan/backup/file/{plan_id}/ | Get File Backup Plan
*PlansBackupApi* | [**get_image_backup_plan_plan_backup_image_plan_id_get**](cybee_sdk/api/docs/PlansBackupApi.md#get_image_backup_plan_plan_backup_image_plan_id_get) | **GET** /plan/backup/image/{plan_id}/ | Get Image Backup Plan
*PlansBackupApi* | [**get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get**](cybee_sdk/api/docs/PlansBackupApi.md#get_running_plan_status_plan_backup_backup_run_plan_run_id_status_get) | **GET** /plan/backup/backup/run/{plan_run_id}/status/ | Get Running Plan Status
*PlansBackupApi* | [**list_all_backup_history_plan_backup_history_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_all_backup_history_plan_backup_history_get) | **GET** /plan/backup/history/ | List All Backup History
*PlansBackupApi* | [**list_all_latest_backup_history_plan_backup_history_latest_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_all_latest_backup_history_plan_backup_history_latest_get) | **GET** /plan/backup/history/latest/ | List All Latest Backup History
*PlansBackupApi* | [**list_file_backup_history_plan_backup_file_plan_id_history_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_file_backup_history_plan_backup_file_plan_id_history_get) | **GET** /plan/backup/file/{plan_id}/history/ | List File Backup History
*PlansBackupApi* | [**list_file_backup_plans_plan_backup_file_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_file_backup_plans_plan_backup_file_get) | **GET** /plan/backup/file/ | List File Backup Plans
*PlansBackupApi* | [**list_image_backup_history_plan_backup_image_plan_id_history_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_image_backup_history_plan_backup_image_plan_id_history_get) | **GET** /plan/backup/image/{plan_id}/history/ | List Image Backup History
*PlansBackupApi* | [**list_image_backup_plans_plan_backup_image_get**](cybee_sdk/api/docs/PlansBackupApi.md#list_image_backup_plans_plan_backup_image_get) | **GET** /plan/backup/image/ | List Image Backup Plans
*PlansBackupApi* | [**remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**](cybee_sdk/api/docs/PlansBackupApi.md#remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/remove-agent/{agent_id}/ | Remove Backup Plan Agent
*PlansBackupApi* | [**remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**](cybee_sdk/api/docs/PlansBackupApi.md#remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/remove-schedule/{schedule_id}/ | Remove Backup Plan Schedule
*PlansBackupApi* | [**update_file_backup_plans_plan_backup_file_plan_id_put**](cybee_sdk/api/docs/PlansBackupApi.md#update_file_backup_plans_plan_backup_file_plan_id_put) | **PUT** /plan/backup/file/{plan_id}/ | Update File Backup Plans
*PlansBackupApi* | [**update_image_backup_plans_plan_backup_image_plan_id_put**](cybee_sdk/api/docs/PlansBackupApi.md#update_image_backup_plans_plan_backup_image_plan_id_put) | **PUT** /plan/backup/image/{plan_id}/ | Update Image Backup Plans
*PlansRestoreApi* | [**assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**](cybee_sdk/api/docs/PlansRestoreApi.md#assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/assign-agent/{agent_id}/ | Assign Restore Plan Agent
*PlansRestoreApi* | [**assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**](cybee_sdk/api/docs/PlansRestoreApi.md#assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/assign-schedule/{schedule_id}/ | Assign Restore Plan Schedule
*PlansRestoreApi* | [**create_file_restore_plans_plan_restore_file_post**](cybee_sdk/api/docs/PlansRestoreApi.md#create_file_restore_plans_plan_restore_file_post) | **POST** /plan/restore/file/ | Create File Restore Plans
*PlansRestoreApi* | [**create_image_restore_plans_plan_restore_image_post**](cybee_sdk/api/docs/PlansRestoreApi.md#create_image_restore_plans_plan_restore_image_post) | **POST** /plan/restore/image/ | Create Image Restore Plans
*PlansRestoreApi* | [**delete_file_restore_plans_plan_restore_file_plan_id_delete**](cybee_sdk/api/docs/PlansRestoreApi.md#delete_file_restore_plans_plan_restore_file_plan_id_delete) | **DELETE** /plan/restore/file/{plan_id}/ | Delete File Restore Plans
*PlansRestoreApi* | [**delete_image_restore_plans_plan_restore_image_plan_id_delete**](cybee_sdk/api/docs/PlansRestoreApi.md#delete_image_restore_plans_plan_restore_image_plan_id_delete) | **DELETE** /plan/restore/image/{plan_id}/ | Delete Image Restore Plans
*PlansRestoreApi* | [**execute_file_restore_plan_plan_restore_file_plan_id_execute_post**](cybee_sdk/api/docs/PlansRestoreApi.md#execute_file_restore_plan_plan_restore_file_plan_id_execute_post) | **POST** /plan/restore/file/{plan_id}/execute/ | Execute File Restore Plan
*PlansRestoreApi* | [**execute_image_restore_plan_plan_restore_image_plan_id_execute_post**](cybee_sdk/api/docs/PlansRestoreApi.md#execute_image_restore_plan_plan_restore_image_plan_id_execute_post) | **POST** /plan/restore/image/{plan_id}/execute/ | Execute Image Restore Plan
*PlansRestoreApi* | [**get_file_restore_plan_plan_restore_file_plan_id_get**](cybee_sdk/api/docs/PlansRestoreApi.md#get_file_restore_plan_plan_restore_file_plan_id_get) | **GET** /plan/restore/file/{plan_id}/ | Get File Restore Plan
*PlansRestoreApi* | [**get_image_restore_plan_plan_restore_image_plan_id_get**](cybee_sdk/api/docs/PlansRestoreApi.md#get_image_restore_plan_plan_restore_image_plan_id_get) | **GET** /plan/restore/image/{plan_id}/ | Get Image Restore Plan
*PlansRestoreApi* | [**get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get**](cybee_sdk/api/docs/PlansRestoreApi.md#get_running_plan_status_plan_restore_restore_run_plan_run_id_status_get) | **GET** /plan/restore/restore/run/{plan_run_id}/status/ | Get Running Plan Status
*PlansRestoreApi* | [**list_all_latest_restore_history_plan_restore_history_latest_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_all_latest_restore_history_plan_restore_history_latest_get) | **GET** /plan/restore/history/latest/ | List All Latest Restore History
*PlansRestoreApi* | [**list_all_restore_history_plan_restore_history_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_all_restore_history_plan_restore_history_get) | **GET** /plan/restore/history/ | List All Restore History
*PlansRestoreApi* | [**list_file_restore_history_plan_restore_file_plan_id_history_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_file_restore_history_plan_restore_file_plan_id_history_get) | **GET** /plan/restore/file/{plan_id}/history/ | List File Restore History
*PlansRestoreApi* | [**list_file_restore_plans_plan_restore_file_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_file_restore_plans_plan_restore_file_get) | **GET** /plan/restore/file/ | List File Restore Plans
*PlansRestoreApi* | [**list_image_restore_history_plan_restore_image_plan_id_history_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_image_restore_history_plan_restore_image_plan_id_history_get) | **GET** /plan/restore/image/{plan_id}/history/ | List Image Restore History
*PlansRestoreApi* | [**list_image_restore_plans_plan_restore_image_get**](cybee_sdk/api/docs/PlansRestoreApi.md#list_image_restore_plans_plan_restore_image_get) | **GET** /plan/restore/image/ | List Image Restore Plans
*PlansRestoreApi* | [**remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**](cybee_sdk/api/docs/PlansRestoreApi.md#remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/remove-agent/{agent_id}/ | Remove Restore Plan Agent
*PlansRestoreApi* | [**remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**](cybee_sdk/api/docs/PlansRestoreApi.md#remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/remove-schedule/{schedule_id}/ | Remove Restore Plan Schedule
*PlansRestoreApi* | [**update_file_restore_plans_plan_restore_file_plan_id_put**](cybee_sdk/api/docs/PlansRestoreApi.md#update_file_restore_plans_plan_restore_file_plan_id_put) | **PUT** /plan/restore/file/{plan_id}/ | Update File Restore Plans
*PlansRestoreApi* | [**update_image_restore_plans_plan_restore_image_plan_id_put**](cybee_sdk/api/docs/PlansRestoreApi.md#update_image_restore_plans_plan_restore_image_plan_id_put) | **PUT** /plan/restore/image/{plan_id}/ | Update Image Restore Plans
*PlansScheduleApi* | [**create_plan_schedule_plan_schedule_schedule_post**](cybee_sdk/api/docs/PlansScheduleApi.md#create_plan_schedule_plan_schedule_schedule_post) | **POST** /plan/schedule/schedule/ | Create Plan Schedule
*PlansScheduleApi* | [**delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**](cybee_sdk/api/docs/PlansScheduleApi.md#delete_plan_schedule_plan_schedule_schedule_schedule_id_delete) | **DELETE** /plan/schedule/schedule/{schedule_id}/ | Delete Plan Schedule
*PlansScheduleApi* | [**list_plan_schedules_plan_schedule_schedule_get**](cybee_sdk/api/docs/PlansScheduleApi.md#list_plan_schedules_plan_schedule_schedule_get) | **GET** /plan/schedule/schedule/ | List Plan Schedules
*PlansScheduleApi* | [**update_plan_schedule_plan_schedule_schedule_schedule_id_put**](cybee_sdk/api/docs/PlansScheduleApi.md#update_plan_schedule_plan_schedule_schedule_schedule_id_put) | **PUT** /plan/schedule/schedule/{schedule_id}/ | Update Plan Schedule
*StorageAccountApi* | [**create_storage_account_storage_storage_account_post**](cybee_sdk/api/docs/StorageAccountApi.md#create_storage_account_storage_storage_account_post) | **POST** /storage/storage-account/ | Create Storage Account
*StorageAccountApi* | [**delete_storage_account_storage_storage_account_storage_account_id_delete**](cybee_sdk/api/docs/StorageAccountApi.md#delete_storage_account_storage_storage_account_storage_account_id_delete) | **DELETE** /storage/storage-account/{storage_account_id}/ | Delete Storage Account
*StorageAccountApi* | [**get_storage_account_storage_storage_account_storage_account_id_get**](cybee_sdk/api/docs/StorageAccountApi.md#get_storage_account_storage_storage_account_storage_account_id_get) | **GET** /storage/storage-account/{storage_account_id}/ | Get Storage Account
*StorageAccountApi* | [**list_storage_account_storage_storage_account_get**](cybee_sdk/api/docs/StorageAccountApi.md#list_storage_account_storage_storage_account_get) | **GET** /storage/storage-account/ | List Storage Account
*StorageAccountApi* | [**update_storage_account_storage_storage_account_storage_account_id_put**](cybee_sdk/api/docs/StorageAccountApi.md#update_storage_account_storage_storage_account_storage_account_id_put) | **PUT** /storage/storage-account/{storage_account_id}/ | Update Storage Account
*StorageDestinationApi* | [**create_storage_destination_storage_storage_destination_post**](cybee_sdk/api/docs/StorageDestinationApi.md#create_storage_destination_storage_storage_destination_post) | **POST** /storage/storage-destination/ | Create Storage Destination
*StorageDestinationApi* | [**delete_storage_destination_storage_storage_destination_storage_destination_id_delete**](cybee_sdk/api/docs/StorageDestinationApi.md#delete_storage_destination_storage_storage_destination_storage_destination_id_delete) | **DELETE** /storage/storage-destination/{storage_destination_id}/ | Delete Storage Destination
*StorageDestinationApi* | [**get_storage_destination_storage_storage_destination_storage_destination_id_get**](cybee_sdk/api/docs/StorageDestinationApi.md#get_storage_destination_storage_storage_destination_storage_destination_id_get) | **GET** /storage/storage-destination/{storage_destination_id}/ | Get Storage Destination
*StorageDestinationApi* | [**list_storage_destination_storage_storage_destination_get**](cybee_sdk/api/docs/StorageDestinationApi.md#list_storage_destination_storage_storage_destination_get) | **GET** /storage/storage-destination/ | List Storage Destination
*StorageDestinationApi* | [**update_storage_destination_storage_storage_destination_storage_destination_id_patch**](cybee_sdk/api/docs/StorageDestinationApi.md#update_storage_destination_storage_storage_destination_storage_destination_id_patch) | **PATCH** /storage/storage-destination/{storage_destination_id}/ | Update Storage Destination
*StorageRepositoryApi* | [**create_repository_storage_repository_post**](cybee_sdk/api/docs/StorageRepositoryApi.md#create_repository_storage_repository_post) | **POST** /storage/repository/ | Create Repository
*StorageRepositoryApi* | [**delete_repository_storage_repository_repository_id_delete**](cybee_sdk/api/docs/StorageRepositoryApi.md#delete_repository_storage_repository_repository_id_delete) | **DELETE** /storage/repository/{repository_id}/ | Delete Repository
*StorageRepositoryApi* | [**execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#execute_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_execute_get) | **GET** /storage/repository/{repository_id}/maintenance/{maintenance_type}/execute/ | Execute Repository Maintenance
*StorageRepositoryApi* | [**get_repository_maintenance_storage_repository_repository_id_maintenance_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#get_repository_maintenance_storage_repository_repository_id_maintenance_get) | **GET** /storage/repository/{repository_id}/maintenance/ | Get Repository Maintenance
*StorageRepositoryApi* | [**get_repository_storage_repository_repository_id_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#get_repository_storage_repository_repository_id_get) | **GET** /storage/repository/{repository_id}/ | Get Repository
*StorageRepositoryApi* | [**list_repository_checks_storage_repository_check_history_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#list_repository_checks_storage_repository_check_history_get) | **GET** /storage/repository/check-history/ | List Repository Checks
*StorageRepositoryApi* | [**list_repository_prunes_storage_repository_prune_history_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#list_repository_prunes_storage_repository_prune_history_get) | **GET** /storage/repository/prune-history/ | List Repository Prunes
*StorageRepositoryApi* | [**list_repository_stats_storage_repository_stats_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#list_repository_stats_storage_repository_stats_get) | **GET** /storage/repository/stats/ | List Repository Stats
*StorageRepositoryApi* | [**list_repository_storage_repository_get**](cybee_sdk/api/docs/StorageRepositoryApi.md#list_repository_storage_repository_get) | **GET** /storage/repository/ | List Repository
*StorageRepositoryApi* | [**set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post**](cybee_sdk/api/docs/StorageRepositoryApi.md#set_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_post) | **POST** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Set Repository Maintenance
*StorageRepositoryApi* | [**unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete**](cybee_sdk/api/docs/StorageRepositoryApi.md#unset_repository_maintenance_storage_repository_repository_id_maintenance_maintenance_type_delete) | **DELETE** /storage/repository/{repository_id}/maintenance/{maintenance_type}/ | Unset Repository Maintenance
*StorageRepositoryApi* | [**update_repository_storage_repository_repository_id_patch**](cybee_sdk/api/docs/StorageRepositoryApi.md#update_repository_storage_repository_repository_id_patch) | **PATCH** /storage/repository/{repository_id}/ | Update Repository


## Documentation For Models

 - [AdditionalAgentFilter](cybee_sdk/api/docs/AdditionalAgentFilter.md)
 - [Addr](cybee_sdk/api/docs/Addr.md)
 - [AgentInfo](cybee_sdk/api/docs/AgentInfo.md)
 - [AgentUpdate](cybee_sdk/api/docs/AgentUpdate.md)
 - [BackupError](cybee_sdk/api/docs/BackupError.md)
 - [BackupFatalError](cybee_sdk/api/docs/BackupFatalError.md)
 - [BackupInfo](cybee_sdk/api/docs/BackupInfo.md)
 - [BackupPlanRun](cybee_sdk/api/docs/BackupPlanRun.md)
 - [BackupStatus](cybee_sdk/api/docs/BackupStatus.md)
 - [BackupSummary](cybee_sdk/api/docs/BackupSummary.md)
 - [BackupVerboseStatus](cybee_sdk/api/docs/BackupVerboseStatus.md)
 - [CoresGroup](cybee_sdk/api/docs/CoresGroup.md)
 - [CreateScheduling](cybee_sdk/api/docs/CreateScheduling.md)
 - [CronCalendar](cybee_sdk/api/docs/CronCalendar.md)
 - [Dns](cybee_sdk/api/docs/Dns.md)
 - [DriveType](cybee_sdk/api/docs/DriveType.md)
 - [ExcludeLargerThan](cybee_sdk/api/docs/ExcludeLargerThan.md)
 - [ExcludeLargerThan1](cybee_sdk/api/docs/ExcludeLargerThan1.md)
 - [FileBackupPlan](cybee_sdk/api/docs/FileBackupPlan.md)
 - [FileBackupPlanCreate](cybee_sdk/api/docs/FileBackupPlanCreate.md)
 - [FileBackupPlanUpdate](cybee_sdk/api/docs/FileBackupPlanUpdate.md)
 - [FileRestorePlan](cybee_sdk/api/docs/FileRestorePlan.md)
 - [FileRestorePlanCreate](cybee_sdk/api/docs/FileRestorePlanCreate.md)
 - [FileRestorePlanUpdate](cybee_sdk/api/docs/FileRestorePlanUpdate.md)
 - [Filesystem](cybee_sdk/api/docs/Filesystem.md)
 - [GlobalResticOptions](cybee_sdk/api/docs/GlobalResticOptions.md)
 - [HTTPValidationError](cybee_sdk/api/docs/HTTPValidationError.md)
 - [HistoricalMachine](cybee_sdk/api/docs/HistoricalMachine.md)
 - [IPVersion](cybee_sdk/api/docs/IPVersion.md)
 - [Iface](cybee_sdk/api/docs/Iface.md)
 - [ImageBackupPlan](cybee_sdk/api/docs/ImageBackupPlan.md)
 - [ImageBackupPlanCreate](cybee_sdk/api/docs/ImageBackupPlanCreate.md)
 - [ImageBackupPlanExtension](cybee_sdk/api/docs/ImageBackupPlanExtension.md)
 - [ImageBackupPlanUpdate](cybee_sdk/api/docs/ImageBackupPlanUpdate.md)
 - [ImageRestorePlan](cybee_sdk/api/docs/ImageRestorePlan.md)
 - [ImageRestorePlanCreate](cybee_sdk/api/docs/ImageRestorePlanCreate.md)
 - [ImageRestorePlanExtension](cybee_sdk/api/docs/ImageRestorePlanExtension.md)
 - [ImageRestorePlanUpdate](cybee_sdk/api/docs/ImageRestorePlanUpdate.md)
 - [LocationInner](cybee_sdk/api/docs/LocationInner.md)
 - [Machine](cybee_sdk/api/docs/Machine.md)
 - [MaintenanceType](cybee_sdk/api/docs/MaintenanceType.md)
 - [MassStorage](cybee_sdk/api/docs/MassStorage.md)
 - [Memory](cybee_sdk/api/docs/Memory.md)
 - [Ntp](cybee_sdk/api/docs/Ntp.md)
 - [NtpSynchronized](cybee_sdk/api/docs/NtpSynchronized.md)
 - [Os](cybee_sdk/api/docs/Os.md)
 - [PageAgentInfo](cybee_sdk/api/docs/PageAgentInfo.md)
 - [PageBackupPlanRun](cybee_sdk/api/docs/PageBackupPlanRun.md)
 - [PageFileBackupPlan](cybee_sdk/api/docs/PageFileBackupPlan.md)
 - [PageFileRestorePlan](cybee_sdk/api/docs/PageFileRestorePlan.md)
 - [PageHistoricalMachine](cybee_sdk/api/docs/PageHistoricalMachine.md)
 - [PageImageBackupPlan](cybee_sdk/api/docs/PageImageBackupPlan.md)
 - [PageImageRestorePlan](cybee_sdk/api/docs/PageImageRestorePlan.md)
 - [PageMachine](cybee_sdk/api/docs/PageMachine.md)
 - [PageRepository](cybee_sdk/api/docs/PageRepository.md)
 - [PageRepositoryChecks](cybee_sdk/api/docs/PageRepositoryChecks.md)
 - [PageRepositoryPrunes](cybee_sdk/api/docs/PageRepositoryPrunes.md)
 - [PageRepositoryStats](cybee_sdk/api/docs/PageRepositoryStats.md)
 - [PageRestorePlanRun](cybee_sdk/api/docs/PageRestorePlanRun.md)
 - [PageScheduling](cybee_sdk/api/docs/PageScheduling.md)
 - [PageStorageAccount](cybee_sdk/api/docs/PageStorageAccount.md)
 - [PageStorageDestination](cybee_sdk/api/docs/PageStorageDestination.md)
 - [PageUnregisteredAgentInfo](cybee_sdk/api/docs/PageUnregisteredAgentInfo.md)
 - [Partition](cybee_sdk/api/docs/Partition.md)
 - [PhyCpu](cybee_sdk/api/docs/PhyCpu.md)
 - [PhyDrive](cybee_sdk/api/docs/PhyDrive.md)
 - [PlanStatus](cybee_sdk/api/docs/PlanStatus.md)
 - [PlanType](cybee_sdk/api/docs/PlanType.md)
 - [PrePostRunScript](cybee_sdk/api/docs/PrePostRunScript.md)
 - [Repository](cybee_sdk/api/docs/Repository.md)
 - [RepositoryChecks](cybee_sdk/api/docs/RepositoryChecks.md)
 - [RepositoryCreate](cybee_sdk/api/docs/RepositoryCreate.md)
 - [RepositoryMaintenance](cybee_sdk/api/docs/RepositoryMaintenance.md)
 - [RepositoryMaintenanceCreateUpdate](cybee_sdk/api/docs/RepositoryMaintenanceCreateUpdate.md)
 - [RepositoryPrunes](cybee_sdk/api/docs/RepositoryPrunes.md)
 - [RepositoryStats](cybee_sdk/api/docs/RepositoryStats.md)
 - [RepositoryStatusEnum](cybee_sdk/api/docs/RepositoryStatusEnum.md)
 - [RepositoryUpdate](cybee_sdk/api/docs/RepositoryUpdate.md)
 - [ResticBackupInput](cybee_sdk/api/docs/ResticBackupInput.md)
 - [ResticBackupOutput](cybee_sdk/api/docs/ResticBackupOutput.md)
 - [ResticRestore](cybee_sdk/api/docs/ResticRestore.md)
 - [ResticStatsModeEnum](cybee_sdk/api/docs/ResticStatsModeEnum.md)
 - [ResticVersionEnum](cybee_sdk/api/docs/ResticVersionEnum.md)
 - [RestorationError](cybee_sdk/api/docs/RestorationError.md)
 - [RestorationInfo](cybee_sdk/api/docs/RestorationInfo.md)
 - [RestorationStatus](cybee_sdk/api/docs/RestorationStatus.md)
 - [RestorationSummary](cybee_sdk/api/docs/RestorationSummary.md)
 - [RestorePlanRun](cybee_sdk/api/docs/RestorePlanRun.md)
 - [RestoreSummary](cybee_sdk/api/docs/RestoreSummary.md)
 - [RestoreVerboseStatus](cybee_sdk/api/docs/RestoreVerboseStatus.md)
 - [RetentionSettings](cybee_sdk/api/docs/RetentionSettings.md)
 - [S3Provider](cybee_sdk/api/docs/S3Provider.md)
 - [S3SignatureVersionEnum](cybee_sdk/api/docs/S3SignatureVersionEnum.md)
 - [S3StorageAccountConfig](cybee_sdk/api/docs/S3StorageAccountConfig.md)
 - [Scheduling](cybee_sdk/api/docs/Scheduling.md)
 - [SchedulingLinkedPlans](cybee_sdk/api/docs/SchedulingLinkedPlans.md)
 - [Snapshot](cybee_sdk/api/docs/Snapshot.md)
 - [StorageAccount](cybee_sdk/api/docs/StorageAccount.md)
 - [StorageAccountCreate](cybee_sdk/api/docs/StorageAccountCreate.md)
 - [StorageAccountUpdate](cybee_sdk/api/docs/StorageAccountUpdate.md)
 - [StorageDestination](cybee_sdk/api/docs/StorageDestination.md)
 - [StorageDestinationConfig](cybee_sdk/api/docs/StorageDestinationConfig.md)
 - [StorageDestinationCreate](cybee_sdk/api/docs/StorageDestinationCreate.md)
 - [StorageDestinationUpdate](cybee_sdk/api/docs/StorageDestinationUpdate.md)
 - [StorageFormat](cybee_sdk/api/docs/StorageFormat.md)
 - [TimeStamps](cybee_sdk/api/docs/TimeStamps.md)
 - [UnregisteredAgentInfo](cybee_sdk/api/docs/UnregisteredAgentInfo.md)
 - [UpdateScheduling](cybee_sdk/api/docs/UpdateScheduling.md)
 - [ValidationError](cybee_sdk/api/docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerToken"></a>
### BearerToken

- **Type**: Bearer authentication

<a id="ZitadelWebAuthorizationBearer"></a>
### ZitadelWebAuthorizationBearer

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://auth.cybee.fr/oauth/v2/authorize
- **Scopes**: N/A


## Author




