# openapi_client.AgentsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**approve_agent_agent_agent_id_approve_post**](AgentsApi.md#approve_agent_agent_agent_id_approve_post) | **POST** /agent/{agent_id}/approve/ | Approve Agent
[**delete_agent_agent_agent_id_delete**](AgentsApi.md#delete_agent_agent_agent_id_delete) | **DELETE** /agent/{agent_id}/ | Delete Agent
[**get_agent_agent_unregistered_get**](AgentsApi.md#get_agent_agent_unregistered_get) | **GET** /agent/unregistered/ | Get Agent
[**list_agent_agent_get**](AgentsApi.md#list_agent_agent_get) | **GET** /agent/ | List Agent
[**update_agent_agent_agent_id_put**](AgentsApi.md#update_agent_agent_agent_id_put) | **PUT** /agent/{agent_id}/ | Update Agent


# **approve_agent_agent_agent_id_approve_post**
> approve_agent_agent_agent_id_approve_post(agent_id)

Approve Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AgentsApi(api_client)
    agent_id = 'agent_id_example' # str | 

    try:
        # Approve Agent
        api_instance.approve_agent_agent_agent_id_approve_post(agent_id)
    except Exception as e:
        print("Exception when calling AgentsApi->approve_agent_agent_agent_id_approve_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_agent_agent_agent_id_delete**
> object delete_agent_agent_agent_id_delete(agent_id)

Delete Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AgentsApi(api_client)
    agent_id = 'agent_id_example' # str | 

    try:
        # Delete Agent
        api_response = api_instance.delete_agent_agent_agent_id_delete(agent_id)
        print("The response of AgentsApi->delete_agent_agent_agent_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->delete_agent_agent_agent_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **str**|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_agent_agent_unregistered_get**
> List[UnregisteredAgentInfo] get_agent_agent_unregistered_get()

Get Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.unregistered_agent_info import UnregisteredAgentInfo
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AgentsApi(api_client)

    try:
        # Get Agent
        api_response = api_instance.get_agent_agent_unregistered_get()
        print("The response of AgentsApi->get_agent_agent_unregistered_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->get_agent_agent_unregistered_get: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[UnregisteredAgentInfo]**](UnregisteredAgentInfo.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_agent_agent_get**
> List[AgentInfo] list_agent_agent_get(id=id, machine_id=machine_id, custom_name=custom_name, host_name=host_name, online=online)

List Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.agent_info import AgentInfo
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AgentsApi(api_client)
    id = ['id_example'] # List[str] |  (optional)
    machine_id = ['machine_id_example'] # List[str] |  (optional)
    custom_name = ['custom_name_example'] # List[str] |  (optional)
    host_name = ['host_name_example'] # List[str] |  (optional)
    online = True # bool |  (optional)

    try:
        # List Agent
        api_response = api_instance.list_agent_agent_get(id=id, machine_id=machine_id, custom_name=custom_name, host_name=host_name, online=online)
        print("The response of AgentsApi->list_agent_agent_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->list_agent_agent_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [**List[str]**](str.md)|  | [optional] 
 **machine_id** | [**List[str]**](str.md)|  | [optional] 
 **custom_name** | [**List[str]**](str.md)|  | [optional] 
 **host_name** | [**List[str]**](str.md)|  | [optional] 
 **online** | **bool**|  | [optional] 

### Return type

[**List[AgentInfo]**](AgentInfo.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_agent_agent_agent_id_put**
> object update_agent_agent_agent_id_put(agent_id, agent_update)

Update Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.agent_update import AgentUpdate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AgentsApi(api_client)
    agent_id = 'agent_id_example' # str | 
    agent_update = openapi_client.AgentUpdate() # AgentUpdate | 

    try:
        # Update Agent
        api_response = api_instance.update_agent_agent_agent_id_put(agent_id, agent_update)
        print("The response of AgentsApi->update_agent_agent_agent_id_put:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AgentsApi->update_agent_agent_agent_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **agent_id** | **str**|  | 
 **agent_update** | [**AgentUpdate**](AgentUpdate.md)|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

