# ImageBackupPlan


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** |  | 
**name** | **str** |  | 
**repo_id** | **str** |  | 
**config** | [**ResticBackupOutput**](ResticBackupOutput.md) |  | 
**retention_config** | [**RetentionSettings**](RetentionSettings.md) |  | [optional] 
**schedule_enabled** | **bool** |  | [optional] [default to False]
**schedule_configs** | **List[str]** |  | [optional] 
**last_executed** | **datetime** |  | [optional] 
**timestamps** | [**TimeStamps**](TimeStamps.md) |  | 
**affected_agents** | **List[str]** |  | [optional] [default to []]
**extension** | [**ImageBackupPlanExtension**](ImageBackupPlanExtension.md) |  | 

## Example

```python
from openapi_client.models.image_backup_plan import ImageBackupPlan

# TODO update the JSON string below
json = "{}"
# create an instance of ImageBackupPlan from a JSON string
image_backup_plan_instance = ImageBackupPlan.from_json(json)
# print the JSON string representation of the object
print(ImageBackupPlan.to_json())

# convert the object into a dict
image_backup_plan_dict = image_backup_plan_instance.to_dict()
# create an instance of ImageBackupPlan from a dict
image_backup_plan_from_dict = ImageBackupPlan.from_dict(image_backup_plan_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


