# openapi_client.PlansBackupApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**](PlansBackupApi.md#assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/assign-agent/{agent_id}/ | Assign Backup Plan Agent
[**assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**](PlansBackupApi.md#assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/assign-schedule/{schedule_id}/ | Assign Backup Plan Schedule
[**create_file_backup_plans_plan_backup_file_post**](PlansBackupApi.md#create_file_backup_plans_plan_backup_file_post) | **POST** /plan/backup/file/ | Create File Backup Plans
[**create_image_backup_plans_plan_backup_image_post**](PlansBackupApi.md#create_image_backup_plans_plan_backup_image_post) | **POST** /plan/backup/image/ | Create Image Backup Plans
[**delete_file_backup_plans_plan_backup_file_plan_id_delete**](PlansBackupApi.md#delete_file_backup_plans_plan_backup_file_plan_id_delete) | **DELETE** /plan/backup/file/{plan_id}/ | Delete File Backup Plans
[**delete_image_backup_plans_plan_backup_image_plan_id_delete**](PlansBackupApi.md#delete_image_backup_plans_plan_backup_image_plan_id_delete) | **DELETE** /plan/backup/image/{plan_id}/ | Delete Image Backup Plans
[**execute_file_backup_plan_plan_backup_file_plan_id_execute_get**](PlansBackupApi.md#execute_file_backup_plan_plan_backup_file_plan_id_execute_get) | **GET** /plan/backup/file/{plan_id}/execute/ | Execute File Backup Plan
[**execute_image_backup_plan_plan_backup_image_plan_id_execute_get**](PlansBackupApi.md#execute_image_backup_plan_plan_backup_image_plan_id_execute_get) | **GET** /plan/backup/image/{plan_id}/execute/ | Execute Image Backup Plan
[**get_file_backup_plan_plan_backup_file_plan_id_get**](PlansBackupApi.md#get_file_backup_plan_plan_backup_file_plan_id_get) | **GET** /plan/backup/file/{plan_id}/ | Get File Backup Plan
[**get_image_backup_plan_plan_backup_image_plan_id_get**](PlansBackupApi.md#get_image_backup_plan_plan_backup_image_plan_id_get) | **GET** /plan/backup/image/{plan_id}/ | Get Image Backup Plan
[**list_file_backup_history_plan_backup_file_plan_id_history_get**](PlansBackupApi.md#list_file_backup_history_plan_backup_file_plan_id_history_get) | **GET** /plan/backup/file/{plan_id}/history/ | List File Backup History
[**list_file_backup_plans_plan_backup_file_get**](PlansBackupApi.md#list_file_backup_plans_plan_backup_file_get) | **GET** /plan/backup/file/ | List File Backup Plans
[**list_image_backup_history_plan_backup_image_plan_id_history_get**](PlansBackupApi.md#list_image_backup_history_plan_backup_image_plan_id_history_get) | **GET** /plan/backup/image/{plan_id}/history/ | List Image Backup History
[**list_image_backup_plans_plan_backup_image_get**](PlansBackupApi.md#list_image_backup_plans_plan_backup_image_get) | **GET** /plan/backup/image/ | List Image Backup Plans
[**remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**](PlansBackupApi.md#remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post) | **POST** /plan/backup/{plan_id}/remove-agent/{agent_id}/ | Remove Backup Plan Agent
[**remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**](PlansBackupApi.md#remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/backup/{plan_id}/remove-schedule/{schedule_id}/ | Remove Backup Plan Schedule
[**update_file_backup_plans_plan_backup_file_plan_id_put**](PlansBackupApi.md#update_file_backup_plans_plan_backup_file_plan_id_put) | **PUT** /plan/backup/file/{plan_id}/ | Update File Backup Plans
[**update_image_backup_plans_plan_backup_image_plan_id_put**](PlansBackupApi.md#update_image_backup_plans_plan_backup_image_plan_id_put) | **PUT** /plan/backup/image/{plan_id}/ | Update Image Backup Plans


# **assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post**
> assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post(plan_id, agent_id)

Assign Backup Plan Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    agent_id = 'agent_id_example' # str | 

    try:
        # Assign Backup Plan Agent
        api_instance.assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post(plan_id, agent_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->assign_backup_plan_agent_plan_backup_plan_id_assign_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **agent_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post**
> assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id)

Assign Backup Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    schedule_id = 'schedule_id_example' # str | 

    try:
        # Assign Backup Plan Schedule
        api_instance.assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->assign_backup_plan_schedule_plan_backup_plan_id_assign_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **schedule_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_file_backup_plans_plan_backup_file_post**
> create_file_backup_plans_plan_backup_file_post(file_backup_plan_create)

Create File Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_backup_plan_create import FileBackupPlanCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    file_backup_plan_create = openapi_client.FileBackupPlanCreate() # FileBackupPlanCreate | 

    try:
        # Create File Backup Plans
        api_instance.create_file_backup_plans_plan_backup_file_post(file_backup_plan_create)
    except Exception as e:
        print("Exception when calling PlansBackupApi->create_file_backup_plans_plan_backup_file_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_backup_plan_create** | [**FileBackupPlanCreate**](FileBackupPlanCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_image_backup_plans_plan_backup_image_post**
> create_image_backup_plans_plan_backup_image_post(image_backup_plan_create)

Create Image Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_backup_plan_create import ImageBackupPlanCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    image_backup_plan_create = openapi_client.ImageBackupPlanCreate() # ImageBackupPlanCreate | 

    try:
        # Create Image Backup Plans
        api_instance.create_image_backup_plans_plan_backup_image_post(image_backup_plan_create)
    except Exception as e:
        print("Exception when calling PlansBackupApi->create_image_backup_plans_plan_backup_image_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **image_backup_plan_create** | [**ImageBackupPlanCreate**](ImageBackupPlanCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_file_backup_plans_plan_backup_file_plan_id_delete**
> delete_file_backup_plans_plan_backup_file_plan_id_delete(plan_id)

Delete File Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Delete File Backup Plans
        api_instance.delete_file_backup_plans_plan_backup_file_plan_id_delete(plan_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->delete_file_backup_plans_plan_backup_file_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_image_backup_plans_plan_backup_image_plan_id_delete**
> delete_image_backup_plans_plan_backup_image_plan_id_delete(plan_id)

Delete Image Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Delete Image Backup Plans
        api_instance.delete_image_backup_plans_plan_backup_image_plan_id_delete(plan_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->delete_image_backup_plans_plan_backup_image_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_file_backup_plan_plan_backup_file_plan_id_execute_get**
> object execute_file_backup_plan_plan_backup_file_plan_id_execute_get(plan_id)

Execute File Backup Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Execute File Backup Plan
        api_response = api_instance.execute_file_backup_plan_plan_backup_file_plan_id_execute_get(plan_id)
        print("The response of PlansBackupApi->execute_file_backup_plan_plan_backup_file_plan_id_execute_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->execute_file_backup_plan_plan_backup_file_plan_id_execute_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_image_backup_plan_plan_backup_image_plan_id_execute_get**
> object execute_image_backup_plan_plan_backup_image_plan_id_execute_get(plan_id)

Execute Image Backup Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Execute Image Backup Plan
        api_response = api_instance.execute_image_backup_plan_plan_backup_image_plan_id_execute_get(plan_id)
        print("The response of PlansBackupApi->execute_image_backup_plan_plan_backup_image_plan_id_execute_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->execute_image_backup_plan_plan_backup_image_plan_id_execute_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_file_backup_plan_plan_backup_file_plan_id_get**
> FileBackupPlan get_file_backup_plan_plan_backup_file_plan_id_get(plan_id)

Get File Backup Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_backup_plan import FileBackupPlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Get File Backup Plan
        api_response = api_instance.get_file_backup_plan_plan_backup_file_plan_id_get(plan_id)
        print("The response of PlansBackupApi->get_file_backup_plan_plan_backup_file_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->get_file_backup_plan_plan_backup_file_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

[**FileBackupPlan**](FileBackupPlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_image_backup_plan_plan_backup_image_plan_id_get**
> ImageBackupPlan get_image_backup_plan_plan_backup_image_plan_id_get(plan_id)

Get Image Backup Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_backup_plan import ImageBackupPlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Get Image Backup Plan
        api_response = api_instance.get_image_backup_plan_plan_backup_image_plan_id_get(plan_id)
        print("The response of PlansBackupApi->get_image_backup_plan_plan_backup_image_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->get_image_backup_plan_plan_backup_image_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

[**ImageBackupPlan**](ImageBackupPlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_backup_history_plan_backup_file_plan_id_history_get**
> PageBackupPlanRun list_file_backup_history_plan_backup_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)

List File Backup History

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_backup_plan_run import PageBackupPlanRun
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List File Backup History
        api_response = api_instance.list_file_backup_history_plan_backup_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansBackupApi->list_file_backup_history_plan_backup_file_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_file_backup_history_plan_backup_file_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_backup_plans_plan_backup_file_get**
> PageFileBackupPlan list_file_backup_plans_plan_backup_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled)

List File Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_file_backup_plan import PageFileBackupPlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = 'id_example' # str |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = 'repo_id_example' # str |  (optional)
    schedule_enabled = True # bool |  (optional)

    try:
        # List File Backup Plans
        api_response = api_instance.list_file_backup_plans_plan_backup_file_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled)
        print("The response of PlansBackupApi->list_file_backup_plans_plan_backup_file_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_file_backup_plans_plan_backup_file_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **repo_id** | **str**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 

### Return type

[**PageFileBackupPlan**](PageFileBackupPlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_backup_history_plan_backup_image_plan_id_history_get**
> PageBackupPlanRun list_image_backup_history_plan_backup_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)

List Image Backup History

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_backup_plan_run import PageBackupPlanRun
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List Image Backup History
        api_response = api_instance.list_image_backup_history_plan_backup_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansBackupApi->list_image_backup_history_plan_backup_image_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_image_backup_history_plan_backup_image_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageBackupPlanRun**](PageBackupPlanRun.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_backup_plans_plan_backup_image_get**
> PageImageBackupPlan list_image_backup_plans_plan_backup_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled)

List Image Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_image_backup_plan import PageImageBackupPlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = 'id_example' # str |  (optional)
    name = 'name_example' # str |  (optional)
    repo_id = 'repo_id_example' # str |  (optional)
    schedule_enabled = True # bool |  (optional)

    try:
        # List Image Backup Plans
        api_response = api_instance.list_image_backup_plans_plan_backup_image_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, repo_id=repo_id, schedule_enabled=schedule_enabled)
        print("The response of PlansBackupApi->list_image_backup_plans_plan_backup_image_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansBackupApi->list_image_backup_plans_plan_backup_image_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **repo_id** | **str**|  | [optional] 
 **schedule_enabled** | **bool**|  | [optional] 

### Return type

[**PageImageBackupPlan**](PageImageBackupPlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post**
> remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post(plan_id, agent_id)

Remove Backup Plan Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    agent_id = 'agent_id_example' # str | 

    try:
        # Remove Backup Plan Agent
        api_instance.remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post(plan_id, agent_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->remove_backup_plan_agent_plan_backup_plan_id_remove_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **agent_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post**
> remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id)

Remove Backup Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    schedule_id = 'schedule_id_example' # str | 

    try:
        # Remove Backup Plan Schedule
        api_instance.remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id)
    except Exception as e:
        print("Exception when calling PlansBackupApi->remove_backup_plan_schedule_plan_backup_plan_id_remove_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **schedule_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_file_backup_plans_plan_backup_file_plan_id_put**
> update_file_backup_plans_plan_backup_file_plan_id_put(plan_id, file_backup_plan_update)

Update File Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_backup_plan_update import FileBackupPlanUpdate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    file_backup_plan_update = openapi_client.FileBackupPlanUpdate() # FileBackupPlanUpdate | 

    try:
        # Update File Backup Plans
        api_instance.update_file_backup_plans_plan_backup_file_plan_id_put(plan_id, file_backup_plan_update)
    except Exception as e:
        print("Exception when calling PlansBackupApi->update_file_backup_plans_plan_backup_file_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **file_backup_plan_update** | [**FileBackupPlanUpdate**](FileBackupPlanUpdate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_image_backup_plans_plan_backup_image_plan_id_put**
> update_image_backup_plans_plan_backup_image_plan_id_put(plan_id, image_backup_plan_update)

Update Image Backup Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_backup_plan_update import ImageBackupPlanUpdate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansBackupApi(api_client)
    plan_id = 'plan_id_example' # str | 
    image_backup_plan_update = openapi_client.ImageBackupPlanUpdate() # ImageBackupPlanUpdate | 

    try:
        # Update Image Backup Plans
        api_instance.update_image_backup_plans_plan_backup_image_plan_id_put(plan_id, image_backup_plan_update)
    except Exception as e:
        print("Exception when calling PlansBackupApi->update_image_backup_plans_plan_backup_image_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **image_backup_plan_update** | [**ImageBackupPlanUpdate**](ImageBackupPlanUpdate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

