# openapi_client.PlansRestoreApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**](PlansRestoreApi.md#assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/assign-agent/{agent_id}/ | Assign Restore Plan Agent
[**assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**](PlansRestoreApi.md#assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/assign-schedule/{schedule_id}/ | Assign Restore Plan Schedule
[**create_file_restore_plans_plan_restore_file_post**](PlansRestoreApi.md#create_file_restore_plans_plan_restore_file_post) | **POST** /plan/restore/file/ | Create File Restore Plans
[**create_image_restore_plans_plan_restore_image_post**](PlansRestoreApi.md#create_image_restore_plans_plan_restore_image_post) | **POST** /plan/restore/image/ | Create Image Restore Plans
[**delete_file_restore_plans_plan_restore_file_plan_id_delete**](PlansRestoreApi.md#delete_file_restore_plans_plan_restore_file_plan_id_delete) | **DELETE** /plan/restore/file/{plan_id}/ | Delete File Restore Plans
[**delete_image_restore_plans_plan_restore_image_plan_id_delete**](PlansRestoreApi.md#delete_image_restore_plans_plan_restore_image_plan_id_delete) | **DELETE** /plan/restore/image/{plan_id}/ | Delete Image Restore Plans
[**execute_file_restore_plan_plan_restore_file_plan_id_execute_get**](PlansRestoreApi.md#execute_file_restore_plan_plan_restore_file_plan_id_execute_get) | **GET** /plan/restore/file/{plan_id}/execute/ | Execute File Restore Plan
[**execute_image_restore_plan_plan_restore_image_plan_id_execute_get**](PlansRestoreApi.md#execute_image_restore_plan_plan_restore_image_plan_id_execute_get) | **GET** /plan/restore/image/{plan_id}/execute/ | Execute Image Restore Plan
[**get_file_restore_plan_plan_restore_file_plan_id_get**](PlansRestoreApi.md#get_file_restore_plan_plan_restore_file_plan_id_get) | **GET** /plan/restore/file/{plan_id}/ | Get File Restore Plan
[**get_image_restore_plan_plan_restore_image_plan_id_get**](PlansRestoreApi.md#get_image_restore_plan_plan_restore_image_plan_id_get) | **GET** /plan/restore/image/{plan_id}/ | Get Image Restore Plan
[**list_file_restore_history_plan_restore_file_plan_id_history_get**](PlansRestoreApi.md#list_file_restore_history_plan_restore_file_plan_id_history_get) | **GET** /plan/restore/file/{plan_id}/history/ | List File Restore History
[**list_file_restore_plans_plan_restore_file_get**](PlansRestoreApi.md#list_file_restore_plans_plan_restore_file_get) | **GET** /plan/restore/file/ | List File Restore Plans
[**list_image_restore_history_plan_restore_image_plan_id_history_get**](PlansRestoreApi.md#list_image_restore_history_plan_restore_image_plan_id_history_get) | **GET** /plan/restore/image/{plan_id}/history/ | List Image Restore History
[**list_image_restore_plans_plan_restore_image_get**](PlansRestoreApi.md#list_image_restore_plans_plan_restore_image_get) | **GET** /plan/restore/image/ | List Image Restore Plans
[**remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**](PlansRestoreApi.md#remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post) | **POST** /plan/restore/{plan_id}/remove-agent/{agent_id}/ | Remove Restore Plan Agent
[**remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**](PlansRestoreApi.md#remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post) | **POST** /plan/restore/{plan_id}/remove-schedule/{schedule_id}/ | Remove Restore Plan Schedule
[**update_file_restore_plans_plan_restore_file_plan_id_put**](PlansRestoreApi.md#update_file_restore_plans_plan_restore_file_plan_id_put) | **PUT** /plan/restore/file/{plan_id}/ | Update File Restore Plans
[**update_image_restore_plans_plan_restore_image_plan_id_put**](PlansRestoreApi.md#update_image_restore_plans_plan_restore_image_plan_id_put) | **PUT** /plan/restore/image/{plan_id}/ | Update Image Restore Plans


# **assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post**
> assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post(plan_id, agent_id)

Assign Restore Plan Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    agent_id = 'agent_id_example' # str | 

    try:
        # Assign Restore Plan Agent
        api_instance.assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post(plan_id, agent_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->assign_restore_plan_agent_plan_restore_plan_id_assign_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **agent_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post**
> assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id)

Assign Restore Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    schedule_id = 'schedule_id_example' # str | 

    try:
        # Assign Restore Plan Schedule
        api_instance.assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post(plan_id, schedule_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->assign_restore_plan_schedule_plan_restore_plan_id_assign_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **schedule_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_file_restore_plans_plan_restore_file_post**
> create_file_restore_plans_plan_restore_file_post(file_restore_plan_create)

Create File Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_restore_plan_create import FileRestorePlanCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    file_restore_plan_create = openapi_client.FileRestorePlanCreate() # FileRestorePlanCreate | 

    try:
        # Create File Restore Plans
        api_instance.create_file_restore_plans_plan_restore_file_post(file_restore_plan_create)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->create_file_restore_plans_plan_restore_file_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_restore_plan_create** | [**FileRestorePlanCreate**](FileRestorePlanCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_image_restore_plans_plan_restore_image_post**
> create_image_restore_plans_plan_restore_image_post(image_restore_plan_create)

Create Image Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_restore_plan_create import ImageRestorePlanCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    image_restore_plan_create = openapi_client.ImageRestorePlanCreate() # ImageRestorePlanCreate | 

    try:
        # Create Image Restore Plans
        api_instance.create_image_restore_plans_plan_restore_image_post(image_restore_plan_create)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->create_image_restore_plans_plan_restore_image_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **image_restore_plan_create** | [**ImageRestorePlanCreate**](ImageRestorePlanCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_file_restore_plans_plan_restore_file_plan_id_delete**
> delete_file_restore_plans_plan_restore_file_plan_id_delete(plan_id)

Delete File Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Delete File Restore Plans
        api_instance.delete_file_restore_plans_plan_restore_file_plan_id_delete(plan_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->delete_file_restore_plans_plan_restore_file_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_image_restore_plans_plan_restore_image_plan_id_delete**
> delete_image_restore_plans_plan_restore_image_plan_id_delete(plan_id)

Delete Image Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Delete Image Restore Plans
        api_instance.delete_image_restore_plans_plan_restore_image_plan_id_delete(plan_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->delete_image_restore_plans_plan_restore_image_plan_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_file_restore_plan_plan_restore_file_plan_id_execute_get**
> object execute_file_restore_plan_plan_restore_file_plan_id_execute_get(plan_id)

Execute File Restore Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Execute File Restore Plan
        api_response = api_instance.execute_file_restore_plan_plan_restore_file_plan_id_execute_get(plan_id)
        print("The response of PlansRestoreApi->execute_file_restore_plan_plan_restore_file_plan_id_execute_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->execute_file_restore_plan_plan_restore_file_plan_id_execute_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **execute_image_restore_plan_plan_restore_image_plan_id_execute_get**
> object execute_image_restore_plan_plan_restore_image_plan_id_execute_get(plan_id)

Execute Image Restore Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Execute Image Restore Plan
        api_response = api_instance.execute_image_restore_plan_plan_restore_image_plan_id_execute_get(plan_id)
        print("The response of PlansRestoreApi->execute_image_restore_plan_plan_restore_image_plan_id_execute_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->execute_image_restore_plan_plan_restore_image_plan_id_execute_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

**object**

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_file_restore_plan_plan_restore_file_plan_id_get**
> FileRestorePlan get_file_restore_plan_plan_restore_file_plan_id_get(plan_id)

Get File Restore Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_restore_plan import FileRestorePlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Get File Restore Plan
        api_response = api_instance.get_file_restore_plan_plan_restore_file_plan_id_get(plan_id)
        print("The response of PlansRestoreApi->get_file_restore_plan_plan_restore_file_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->get_file_restore_plan_plan_restore_file_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

[**FileRestorePlan**](FileRestorePlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_image_restore_plan_plan_restore_image_plan_id_get**
> ImageRestorePlan get_image_restore_plan_plan_restore_image_plan_id_get(plan_id)

Get Image Restore Plan

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_restore_plan import ImageRestorePlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 

    try:
        # Get Image Restore Plan
        api_response = api_instance.get_image_restore_plan_plan_restore_image_plan_id_get(plan_id)
        print("The response of PlansRestoreApi->get_image_restore_plan_plan_restore_image_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->get_image_restore_plan_plan_restore_image_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 

### Return type

[**ImageRestorePlan**](ImageRestorePlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_restore_history_plan_restore_file_plan_id_history_get**
> PageRestorePlanRun list_file_restore_history_plan_restore_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)

List File Restore History

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_restore_plan_run import PageRestorePlanRun
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List File Restore History
        api_response = api_instance.list_file_restore_history_plan_restore_file_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansRestoreApi->list_file_restore_history_plan_restore_file_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_file_restore_history_plan_restore_file_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_file_restore_plans_plan_restore_file_get**
> PageFileRestorePlan list_file_restore_plans_plan_restore_file_get(page=page, per_page=per_page, order_by=order_by)

List File Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_file_restore_plan import PageFileRestorePlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List File Restore Plans
        api_response = api_instance.list_file_restore_plans_plan_restore_file_get(page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansRestoreApi->list_file_restore_plans_plan_restore_file_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_file_restore_plans_plan_restore_file_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageFileRestorePlan**](PageFileRestorePlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_restore_history_plan_restore_image_plan_id_history_get**
> PageRestorePlanRun list_image_restore_history_plan_restore_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)

List Image Restore History

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_restore_plan_run import PageRestorePlanRun
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List Image Restore History
        api_response = api_instance.list_image_restore_history_plan_restore_image_plan_id_history_get(plan_id, page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansRestoreApi->list_image_restore_history_plan_restore_image_plan_id_history_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_image_restore_history_plan_restore_image_plan_id_history_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageRestorePlanRun**](PageRestorePlanRun.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_image_restore_plans_plan_restore_image_get**
> PageImageRestorePlan list_image_restore_plans_plan_restore_image_get(page=page, per_page=per_page, order_by=order_by)

List Image Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_image_restore_plan import PageImageRestorePlan
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List Image Restore Plans
        api_response = api_instance.list_image_restore_plans_plan_restore_image_get(page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansRestoreApi->list_image_restore_plans_plan_restore_image_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->list_image_restore_plans_plan_restore_image_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageImageRestorePlan**](PageImageRestorePlan.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post**
> remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post(plan_id, agent_id)

Remove Restore Plan Agent

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    agent_id = 'agent_id_example' # str | 

    try:
        # Remove Restore Plan Agent
        api_instance.remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post(plan_id, agent_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->remove_restore_plan_agent_plan_restore_plan_id_remove_agent_agent_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **agent_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post**
> remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id)

Remove Restore Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    schedule_id = 'schedule_id_example' # str | 

    try:
        # Remove Restore Plan Schedule
        api_instance.remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post(plan_id, schedule_id)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->remove_restore_plan_schedule_plan_restore_plan_id_remove_schedule_schedule_id_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **schedule_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_file_restore_plans_plan_restore_file_plan_id_put**
> update_file_restore_plans_plan_restore_file_plan_id_put(plan_id, file_restore_plan_update)

Update File Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.file_restore_plan_update import FileRestorePlanUpdate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    file_restore_plan_update = openapi_client.FileRestorePlanUpdate() # FileRestorePlanUpdate | 

    try:
        # Update File Restore Plans
        api_instance.update_file_restore_plans_plan_restore_file_plan_id_put(plan_id, file_restore_plan_update)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->update_file_restore_plans_plan_restore_file_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **file_restore_plan_update** | [**FileRestorePlanUpdate**](FileRestorePlanUpdate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_image_restore_plans_plan_restore_image_plan_id_put**
> update_image_restore_plans_plan_restore_image_plan_id_put(plan_id, image_restore_plan_update)

Update Image Restore Plans

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.image_restore_plan_update import ImageRestorePlanUpdate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansRestoreApi(api_client)
    plan_id = 'plan_id_example' # str | 
    image_restore_plan_update = openapi_client.ImageRestorePlanUpdate() # ImageRestorePlanUpdate | 

    try:
        # Update Image Restore Plans
        api_instance.update_image_restore_plans_plan_restore_image_plan_id_put(plan_id, image_restore_plan_update)
    except Exception as e:
        print("Exception when calling PlansRestoreApi->update_image_restore_plans_plan_restore_image_plan_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **plan_id** | **str**|  | 
 **image_restore_plan_update** | [**ImageRestorePlanUpdate**](ImageRestorePlanUpdate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

