# openapi_client.PlansScheduleApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_plan_schedule_plan_schedule_schedule_post**](PlansScheduleApi.md#create_plan_schedule_plan_schedule_schedule_post) | **POST** /plan/schedule/schedule/ | Create Plan Schedule
[**delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**](PlansScheduleApi.md#delete_plan_schedule_plan_schedule_schedule_schedule_id_delete) | **DELETE** /plan/schedule/schedule/{schedule_id}/ | Delete Plan Schedule
[**list_plan_schedules_plan_schedule_schedule_get**](PlansScheduleApi.md#list_plan_schedules_plan_schedule_schedule_get) | **GET** /plan/schedule/schedule/ | List Plan Schedules
[**update_plan_schedule_plan_schedule_schedule_schedule_id_put**](PlansScheduleApi.md#update_plan_schedule_plan_schedule_schedule_schedule_id_put) | **PUT** /plan/schedule/schedule/{schedule_id}/ | Update Plan Schedule


# **create_plan_schedule_plan_schedule_schedule_post**
> Scheduling create_plan_schedule_plan_schedule_schedule_post(create_scheduling)

Create Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.create_scheduling import CreateScheduling
from openapi_client.models.scheduling import Scheduling
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansScheduleApi(api_client)
    create_scheduling = openapi_client.CreateScheduling() # CreateScheduling | 

    try:
        # Create Plan Schedule
        api_response = api_instance.create_plan_schedule_plan_schedule_schedule_post(create_scheduling)
        print("The response of PlansScheduleApi->create_plan_schedule_plan_schedule_schedule_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->create_plan_schedule_plan_schedule_schedule_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_scheduling** | [**CreateScheduling**](CreateScheduling.md)|  | 

### Return type

[**Scheduling**](Scheduling.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_plan_schedule_plan_schedule_schedule_schedule_id_delete**
> delete_plan_schedule_plan_schedule_schedule_schedule_id_delete(schedule_id)

Delete Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansScheduleApi(api_client)
    schedule_id = 'schedule_id_example' # str | 

    try:
        # Delete Plan Schedule
        api_instance.delete_plan_schedule_plan_schedule_schedule_schedule_id_delete(schedule_id)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->delete_plan_schedule_plan_schedule_schedule_schedule_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_plan_schedules_plan_schedule_schedule_get**
> PageScheduling list_plan_schedules_plan_schedule_schedule_get(page=page, per_page=per_page, order_by=order_by)

List Plan Schedules

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_scheduling import PageScheduling
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansScheduleApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])

    try:
        # List Plan Schedules
        api_response = api_instance.list_plan_schedules_plan_schedule_schedule_get(page=page, per_page=per_page, order_by=order_by)
        print("The response of PlansScheduleApi->list_plan_schedules_plan_schedule_schedule_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->list_plan_schedules_plan_schedule_schedule_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]

### Return type

[**PageScheduling**](PageScheduling.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_plan_schedule_plan_schedule_schedule_schedule_id_put**
> update_plan_schedule_plan_schedule_schedule_schedule_id_put(schedule_id, update_scheduling)

Update Plan Schedule

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.update_scheduling import UpdateScheduling
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlansScheduleApi(api_client)
    schedule_id = 'schedule_id_example' # str | 
    update_scheduling = openapi_client.UpdateScheduling() # UpdateScheduling | 

    try:
        # Update Plan Schedule
        api_instance.update_plan_schedule_plan_schedule_schedule_schedule_id_put(schedule_id, update_scheduling)
    except Exception as e:
        print("Exception when calling PlansScheduleApi->update_plan_schedule_plan_schedule_schedule_schedule_id_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **str**|  | 
 **update_scheduling** | [**UpdateScheduling**](UpdateScheduling.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

