# openapi_client.StorageDestinationApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_storage_destination_storage_storage_destination_post**](StorageDestinationApi.md#create_storage_destination_storage_storage_destination_post) | **POST** /storage/storage-destination/ | Create Storage Destination
[**delete_storage_destination_storage_storage_destination_storage_destination_id_delete**](StorageDestinationApi.md#delete_storage_destination_storage_storage_destination_storage_destination_id_delete) | **DELETE** /storage/storage-destination/{storage_destination_id}/ | Delete Storage Destination
[**get_storage_destination_storage_storage_destination_storage_destination_id_get**](StorageDestinationApi.md#get_storage_destination_storage_storage_destination_storage_destination_id_get) | **GET** /storage/storage-destination/{storage_destination_id}/ | Get Storage Destination
[**list_storage_destination_storage_storage_destination_get**](StorageDestinationApi.md#list_storage_destination_storage_storage_destination_get) | **GET** /storage/storage-destination/ | List Storage Destination


# **create_storage_destination_storage_storage_destination_post**
> create_storage_destination_storage_storage_destination_post(storage_destination_create)

Create Storage Destination

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.storage_destination_create import StorageDestinationCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageDestinationApi(api_client)
    storage_destination_create = openapi_client.StorageDestinationCreate() # StorageDestinationCreate | 

    try:
        # Create Storage Destination
        api_instance.create_storage_destination_storage_storage_destination_post(storage_destination_create)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->create_storage_destination_storage_storage_destination_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_create** | [**StorageDestinationCreate**](StorageDestinationCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_storage_destination_storage_storage_destination_storage_destination_id_delete**
> delete_storage_destination_storage_storage_destination_storage_destination_id_delete(storage_destination_id)

Delete Storage Destination

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageDestinationApi(api_client)
    storage_destination_id = 'storage_destination_id_example' # str | 

    try:
        # Delete Storage Destination
        api_instance.delete_storage_destination_storage_storage_destination_storage_destination_id_delete(storage_destination_id)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->delete_storage_destination_storage_storage_destination_storage_destination_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_storage_destination_storage_storage_destination_storage_destination_id_get**
> StorageDestination get_storage_destination_storage_storage_destination_storage_destination_id_get(storage_destination_id)

Get Storage Destination

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.storage_destination import StorageDestination
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageDestinationApi(api_client)
    storage_destination_id = 'storage_destination_id_example' # str | 

    try:
        # Get Storage Destination
        api_response = api_instance.get_storage_destination_storage_storage_destination_storage_destination_id_get(storage_destination_id)
        print("The response of StorageDestinationApi->get_storage_destination_storage_storage_destination_storage_destination_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->get_storage_destination_storage_storage_destination_storage_destination_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **storage_destination_id** | **str**|  | 

### Return type

[**StorageDestination**](StorageDestination.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_storage_destination_storage_storage_destination_get**
> PageStorageDestination list_storage_destination_storage_storage_destination_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, base_path=base_path, storage_account_id=storage_account_id)

List Storage Destination

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_storage_destination import PageStorageDestination
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageDestinationApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[Optional[str]] |  (optional) (default to [])
    id = 'id_example' # str |  (optional)
    name = 'name_example' # str |  (optional)
    base_path = 'base_path_example' # str |  (optional)
    storage_account_id = 'storage_account_id_example' # str |  (optional)

    try:
        # List Storage Destination
        api_response = api_instance.list_storage_destination_storage_storage_destination_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, base_path=base_path, storage_account_id=storage_account_id)
        print("The response of StorageDestinationApi->list_storage_destination_storage_storage_destination_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageDestinationApi->list_storage_destination_storage_storage_destination_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[Optional[str]]**](str.md)|  | [optional] [default to []]
 **id** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **base_path** | **str**|  | [optional] 
 **storage_account_id** | **str**|  | [optional] 

### Return type

[**PageStorageDestination**](PageStorageDestination.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

