# openapi_client.StorageRepositoryApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_repository_storage_repository_post**](StorageRepositoryApi.md#create_repository_storage_repository_post) | **POST** /storage/repository/ | Create Repository
[**delete_repository_storage_repository_repository_id_delete**](StorageRepositoryApi.md#delete_repository_storage_repository_repository_id_delete) | **DELETE** /storage/repository/{repository_id}/ | Delete Repository
[**get_repository_storage_repository_repository_id_get**](StorageRepositoryApi.md#get_repository_storage_repository_repository_id_get) | **GET** /storage/repository/{repository_id}/ | Get Repository
[**list_repository_storage_repository_get**](StorageRepositoryApi.md#list_repository_storage_repository_get) | **GET** /storage/repository/ | List Repository


# **create_repository_storage_repository_post**
> create_repository_storage_repository_post(repository_create)

Create Repository

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.repository_create import RepositoryCreate
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageRepositoryApi(api_client)
    repository_create = openapi_client.RepositoryCreate() # RepositoryCreate | 

    try:
        # Create Repository
        api_instance.create_repository_storage_repository_post(repository_create)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->create_repository_storage_repository_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_create** | [**RepositoryCreate**](RepositoryCreate.md)|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_repository_storage_repository_repository_id_delete**
> delete_repository_storage_repository_repository_id_delete(repository_id)

Delete Repository

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageRepositoryApi(api_client)
    repository_id = 'repository_id_example' # str | 

    try:
        # Delete Repository
        api_instance.delete_repository_storage_repository_repository_id_delete(repository_id)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->delete_repository_storage_repository_repository_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_repository_storage_repository_repository_id_get**
> Repository get_repository_storage_repository_repository_id_get(repository_id)

Get Repository

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.repository import Repository
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageRepositoryApi(api_client)
    repository_id = 'repository_id_example' # str | 

    try:
        # Get Repository
        api_response = api_instance.get_repository_storage_repository_repository_id_get(repository_id)
        print("The response of StorageRepositoryApi->get_repository_storage_repository_repository_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->get_repository_storage_repository_repository_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **repository_id** | **str**|  | 

### Return type

[**Repository**](Repository.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_repository_storage_repository_get**
> PageRepository list_repository_storage_repository_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, slug=slug, status=status, storage_destinaiton_id=storage_destinaiton_id, version=version)

List Repository

### Example

* OAuth Authentication (ZitadelAuthorizationCodeBearer):

```python
import openapi_client
from openapi_client.models.page_repository import PageRepository
from openapi_client.models.repository_status_enum import RepositoryStatusEnum
from openapi_client.models.restic_version_enum import ResticVersionEnum
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.StorageRepositoryApi(api_client)
    page = 0 # int |  (optional) (default to 0)
    per_page = 25 # int |  (optional) (default to 25)
    order_by = [] # List[str] |  (optional) (default to [])
    id = 'id_example' # str |  (optional)
    name = 'name_example' # str |  (optional)
    slug = 'slug_example' # str |  (optional)
    status = openapi_client.RepositoryStatusEnum() # RepositoryStatusEnum |  (optional)
    storage_destinaiton_id = 'storage_destinaiton_id_example' # str |  (optional)
    version = openapi_client.ResticVersionEnum() # ResticVersionEnum |  (optional)

    try:
        # List Repository
        api_response = api_instance.list_repository_storage_repository_get(page=page, per_page=per_page, order_by=order_by, id=id, name=name, slug=slug, status=status, storage_destinaiton_id=storage_destinaiton_id, version=version)
        print("The response of StorageRepositoryApi->list_repository_storage_repository_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StorageRepositoryApi->list_repository_storage_repository_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**|  | [optional] [default to 0]
 **per_page** | **int**|  | [optional] [default to 25]
 **order_by** | [**List[str]**](str.md)|  | [optional] [default to []]
 **id** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **slug** | **str**|  | [optional] 
 **status** | [**RepositoryStatusEnum**](.md)|  | [optional] 
 **storage_destinaiton_id** | **str**|  | [optional] 
 **version** | [**ResticVersionEnum**](.md)|  | [optional] 

### Return type

[**PageRepository**](PageRepository.md)

### Authorization

[ZitadelAuthorizationCodeBearer](../README.md#ZitadelAuthorizationCodeBearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**422** | Validation Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

